/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.payment;

import de.adorsys.psd2.xs2a.core.profile.PaymentType;
import de.adorsys.psd2.xs2a.core.tpp.TppInfo;
import de.adorsys.psd2.xs2a.domain.MessageErrorCode;
import de.adorsys.psd2.xs2a.domain.ResponseObject;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aPisConsent;
import de.adorsys.psd2.xs2a.domain.consent.Xsa2CreatePisConsentAuthorisationResponse;
import de.adorsys.psd2.xs2a.domain.pis.BulkPayment;
import de.adorsys.psd2.xs2a.domain.pis.BulkPaymentInitiationResponse;
import de.adorsys.psd2.xs2a.domain.pis.PaymentInitiationParameters;
import de.adorsys.psd2.xs2a.domain.pis.SinglePayment;
import de.adorsys.psd2.xs2a.exception.MessageError;
import de.adorsys.psd2.xs2a.service.authorization.AuthorisationMethodService;
import de.adorsys.psd2.xs2a.service.authorization.pis.PisScaAuthorisationService;
import de.adorsys.psd2.xs2a.service.consent.PisConsentDataService;
import de.adorsys.psd2.xs2a.service.consent.Xs2aPisConsentService;
import de.adorsys.psd2.xs2a.service.payment.CreatePaymentService;
import de.adorsys.psd2.xs2a.service.payment.ScaPaymentService;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Optional;
import org.springframework.stereotype.Service;

@Service
public class CreateBulkPaymentService
implements CreatePaymentService<BulkPayment, BulkPaymentInitiationResponse> {
    private final ScaPaymentService scaPaymentService;
    private final Xs2aPisConsentService pisConsentService;
    private final AuthorisationMethodService authorisationMethodService;
    private final PisScaAuthorisationService pisScaAuthorisationService;
    private final PisConsentDataService pisConsentDataService;

    @Override
    public ResponseObject<BulkPaymentInitiationResponse> createPayment(BulkPayment bulkPayment, PaymentInitiationParameters paymentInitiationParameters, TppInfo tppInfo, Xs2aPisConsent pisConsent) {
        String externalPaymentId = pisConsent.getConsentId();
        String internalPaymentId = this.pisConsentDataService.getInternalPaymentIdByEncryptedString(externalPaymentId);
        bulkPayment.setPaymentId(internalPaymentId);
        BulkPaymentInitiationResponse response = this.scaPaymentService.createBulkPayment(bulkPayment, tppInfo, paymentInitiationParameters.getPaymentProduct(), pisConsent);
        response.setPisConsentId(pisConsent.getConsentId());
        bulkPayment.setTransactionStatus(response.getTransactionStatus());
        this.updateBulkPaymentIds(bulkPayment.getPayments(), internalPaymentId);
        this.pisConsentService.updateBulkPaymentInPisConsent(bulkPayment, paymentInitiationParameters, pisConsent.getConsentId());
        boolean implicitMethod = this.authorisationMethodService.isImplicitMethod(paymentInitiationParameters.isTppExplicitAuthorisationPreferred());
        if (implicitMethod) {
            Optional<Xsa2CreatePisConsentAuthorisationResponse> consentAuthorisation = this.pisScaAuthorisationService.createConsentAuthorisation(externalPaymentId, PaymentType.BULK, paymentInitiationParameters.getPsuData());
            if (!consentAuthorisation.isPresent()) {
                return ResponseObject.builder().fail(new MessageError(MessageErrorCode.CONSENT_INVALID)).build();
            }
            Xsa2CreatePisConsentAuthorisationResponse authorisationResponse = consentAuthorisation.get();
            response.setAuthorizationId(authorisationResponse.getAuthorizationId());
            response.setScaStatus(authorisationResponse.getScaStatus());
        }
        response.setPaymentId(externalPaymentId);
        return ResponseObject.builder().body(response).build();
    }

    private void updateBulkPaymentIds(List<SinglePayment> payments, String paymentId) {
        payments.forEach(p -> p.setPaymentId(paymentId));
    }

    @ConstructorProperties(value={"scaPaymentService", "pisConsentService", "authorisationMethodService", "pisScaAuthorisationService", "pisConsentDataService"})
    public CreateBulkPaymentService(ScaPaymentService scaPaymentService, Xs2aPisConsentService pisConsentService, AuthorisationMethodService authorisationMethodService, PisScaAuthorisationService pisScaAuthorisationService, PisConsentDataService pisConsentDataService) {
        this.scaPaymentService = scaPaymentService;
        this.pisConsentService = pisConsentService;
        this.authorisationMethodService = authorisationMethodService;
        this.pisScaAuthorisationService = pisScaAuthorisationService;
        this.pisConsentDataService = pisConsentDataService;
    }
}

