/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.payment;

import de.adorsys.psd2.xs2a.core.consent.AspspConsentData;
import de.adorsys.psd2.xs2a.core.pis.TransactionStatus;
import de.adorsys.psd2.xs2a.domain.MessageErrorCode;
import de.adorsys.psd2.xs2a.domain.ResponseObject;
import de.adorsys.psd2.xs2a.domain.pis.CancelPaymentResponse;
import de.adorsys.psd2.xs2a.exception.MessageError;
import de.adorsys.psd2.xs2a.service.consent.PisConsentDataService;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aCancelPaymentMapper;
import de.adorsys.psd2.xs2a.spi.domain.payment.response.SpiPaymentCancellationResponse;
import de.adorsys.psd2.xs2a.spi.domain.psu.SpiPsuData;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import de.adorsys.psd2.xs2a.spi.service.PaymentCancellationSpi;
import de.adorsys.psd2.xs2a.spi.service.SpiPayment;
import java.beans.ConstructorProperties;
import java.util.Optional;
import org.springframework.stereotype.Service;

@Service
public class CancelPaymentService {
    private final PaymentCancellationSpi paymentCancellationSpi;
    private final SpiToXs2aCancelPaymentMapper spiToXs2aCancelPaymentMapper;
    private final PisConsentDataService pisConsentDataService;

    public ResponseObject<CancelPaymentResponse> cancelPaymentWithoutAuthorisation(SpiPsuData psuData, SpiPayment payment, AspspConsentData consentData) {
        SpiResponse spiResponse = this.paymentCancellationSpi.cancelPaymentWithoutSca(psuData, payment, consentData);
        this.pisConsentDataService.updateAspspConsentData(spiResponse.getAspspConsentData());
        if (spiResponse.hasError()) {
            return ResponseObject.builder().fail(new MessageError(MessageErrorCode.RESOURCE_UNKNOWN_403)).build();
        }
        CancelPaymentResponse cancelPaymentResponse = new CancelPaymentResponse();
        cancelPaymentResponse.setTransactionStatus(TransactionStatus.CANC);
        return ResponseObject.builder().body(cancelPaymentResponse).build();
    }

    public ResponseObject<CancelPaymentResponse> initiatePaymentCancellation(SpiPsuData psuData, SpiPayment payment, AspspConsentData consentData) {
        SpiResponse spiResponse = this.paymentCancellationSpi.initiatePaymentCancellation(psuData, payment, consentData);
        this.pisConsentDataService.updateAspspConsentData(spiResponse.getAspspConsentData());
        if (spiResponse.hasError()) {
            return ResponseObject.builder().fail(new MessageError(MessageErrorCode.RESOURCE_UNKNOWN_403)).build();
        }
        CancelPaymentResponse cancelPaymentResponse = this.spiToXs2aCancelPaymentMapper.mapToCancelPaymentResponse((SpiPaymentCancellationResponse)spiResponse.getPayload());
        return Optional.ofNullable(cancelPaymentResponse).map(p -> ResponseObject.builder().body((CancelPaymentResponse)p).build()).orElseGet(ResponseObject.builder().fail(new MessageError(MessageErrorCode.RESOURCE_UNKNOWN_403))::build);
    }

    @ConstructorProperties(value={"paymentCancellationSpi", "spiToXs2aCancelPaymentMapper", "pisConsentDataService"})
    public CancelPaymentService(PaymentCancellationSpi paymentCancellationSpi, SpiToXs2aCancelPaymentMapper spiToXs2aCancelPaymentMapper, PisConsentDataService pisConsentDataService) {
        this.paymentCancellationSpi = paymentCancellationSpi;
        this.spiToXs2aCancelPaymentMapper = spiToXs2aCancelPaymentMapper;
        this.pisConsentDataService = pisConsentDataService;
    }
}

