/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers;

import de.adorsys.psd2.xs2a.core.profile.AccountReference;
import de.adorsys.psd2.xs2a.domain.account.Xs2aAccountReference;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountReference;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Component;

@Component
public class Xs2aToSpiAccountReferenceMapper {
    public SpiAccountReference mapToSpiAccountReference(Xs2aAccountReference account) {
        return new SpiAccountReference(account.getResourceId(), account.getIban(), account.getBban(), account.getPan(), account.getMaskedPan(), account.getMsisdn(), account.getCurrency());
    }

    public List<SpiAccountReference> mapToSpiAccountReferences(List<Xs2aAccountReference> references) {
        if (CollectionUtils.isEmpty(references)) {
            return Collections.emptyList();
        }
        return references.stream().map(ref -> Optional.ofNullable(ref).map(this::mapToSpiAccountReference).orElse(null)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public SpiAccountReference mapToSpiAccountReference(AccountReference account) {
        return new SpiAccountReference(account.getResourceId(), account.getIban(), account.getBban(), account.getPan(), account.getMaskedPan(), account.getMsisdn(), account.getCurrency());
    }
}

