/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers;

import de.adorsys.psd2.xs2a.domain.Transactions;
import de.adorsys.psd2.xs2a.domain.account.Xs2aAccountReport;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aTransactionMapper;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiTransaction;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class SpiTransactionListToXs2aAccountReportMapper {
    private final SpiToXs2aTransactionMapper toXs2aTransactionMapper;

    public Optional<Xs2aAccountReport> mapToXs2aAccountReport(List<SpiTransaction> spiTransactions) {
        if (spiTransactions.isEmpty()) {
            return Optional.empty();
        }
        List<Transactions> booked = spiTransactions.stream().filter(transaction -> transaction.getBookingDate() != null).map(this.toXs2aTransactionMapper::mapToXs2aTransaction).collect(Collectors.toList());
        List<Transactions> pending = spiTransactions.stream().filter(transaction -> transaction.getBookingDate() == null).map(this.toXs2aTransactionMapper::mapToXs2aTransaction).collect(Collectors.toList());
        return Optional.of(new Xs2aAccountReport(booked, pending));
    }

    @ConstructorProperties(value={"toXs2aTransactionMapper"})
    public SpiTransactionListToXs2aAccountReportMapper(SpiToXs2aTransactionMapper toXs2aTransactionMapper) {
        this.toXs2aTransactionMapper = toXs2aTransactionMapper;
    }
}

