/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers;

import de.adorsys.psd2.xs2a.core.pis.TransactionStatus;
import de.adorsys.psd2.xs2a.domain.pis.SinglePayment;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aAccountReferenceMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aAddressMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aAmountMapper;
import de.adorsys.psd2.xs2a.spi.domain.payment.SpiSinglePayment;
import java.beans.ConstructorProperties;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
public class SpiToXs2aSinglePaymentMapper {
    private final SpiToXs2aAccountReferenceMapper spiToXs2aAccountReferenceMapper;
    private final SpiToXs2aAmountMapper spiToXs2aAmountMapper;
    private final SpiToXs2aAddressMapper spiToXs2aAddressMapper;

    public SinglePayment mapToXs2aSinglePayment(@NotNull SpiSinglePayment payment) {
        SinglePayment single = new SinglePayment();
        single.setPaymentId(payment.getPaymentId());
        single.setEndToEndIdentification(payment.getEndToEndIdentification());
        single.setDebtorAccount(this.spiToXs2aAccountReferenceMapper.mapToXs2aAccountReference(payment.getDebtorAccount()).orElse(null));
        single.setInstructedAmount(this.spiToXs2aAmountMapper.mapToXs2aAmount(payment.getInstructedAmount()));
        single.setCreditorAccount(this.spiToXs2aAccountReferenceMapper.mapToXs2aAccountReference(payment.getCreditorAccount()).orElse(null));
        single.setCreditorAgent(payment.getCreditorAgent());
        single.setCreditorName(payment.getCreditorName());
        single.setCreditorAddress(this.spiToXs2aAddressMapper.mapToAddress(payment.getCreditorAddress()));
        single.setRemittanceInformationUnstructured(payment.getRemittanceInformationUnstructured());
        single.setTransactionStatus(TransactionStatus.getByValue((String)payment.getPaymentStatus().getName()));
        return single;
    }

    @ConstructorProperties(value={"spiToXs2aAccountReferenceMapper", "spiToXs2aAmountMapper", "spiToXs2aAddressMapper"})
    public SpiToXs2aSinglePaymentMapper(SpiToXs2aAccountReferenceMapper spiToXs2aAccountReferenceMapper, SpiToXs2aAmountMapper spiToXs2aAmountMapper, SpiToXs2aAddressMapper spiToXs2aAddressMapper) {
        this.spiToXs2aAccountReferenceMapper = spiToXs2aAccountReferenceMapper;
        this.spiToXs2aAmountMapper = spiToXs2aAmountMapper;
        this.spiToXs2aAddressMapper = spiToXs2aAddressMapper;
    }
}

