/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers;

import de.adorsys.psd2.xs2a.domain.Xs2aExchangeRate;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiExchangeRate;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class SpiToXs2aExchangeRateMapper {
    public Xs2aExchangeRate mapToExchangeRate(SpiExchangeRate spiExchangeRate) {
        return Optional.ofNullable(spiExchangeRate).map(e -> {
            Xs2aExchangeRate exchangeRate = new Xs2aExchangeRate();
            exchangeRate.setCurrencyFrom(e.getCurrencyFrom());
            exchangeRate.setRateFrom(e.getRateFrom());
            exchangeRate.setCurrencyTo(e.getCurrencyTo());
            exchangeRate.setRateTo(e.getRateTo());
            exchangeRate.setRateDate(e.getRateDate());
            exchangeRate.setRateContract(e.getRateContract());
            return exchangeRate;
        }).orElse(null);
    }

    public List<Xs2aExchangeRate> mapToExchangeRateList(List<SpiExchangeRate> spiExchangeRates) {
        if (CollectionUtils.isEmpty(spiExchangeRates)) {
            return new ArrayList<Xs2aExchangeRate>();
        }
        return spiExchangeRates.stream().map(this::mapToExchangeRate).collect(Collectors.toList());
    }
}

