/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers;

import de.adorsys.psd2.xs2a.domain.CashAccountType;
import de.adorsys.psd2.xs2a.domain.account.AccountStatus;
import de.adorsys.psd2.xs2a.domain.account.Xs2aAccountDetails;
import de.adorsys.psd2.xs2a.domain.account.Xs2aUsageType;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aBalanceMapper;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountDetails;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountStatus;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountType;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiUsageType;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Component;

@Component
public class SpiToXs2aAccountDetailsMapper {
    private final SpiToXs2aBalanceMapper balanceMapper;

    public Xs2aAccountDetails mapToXs2aAccountDetails(SpiAccountDetails accountDetails) {
        return Optional.ofNullable(accountDetails).map(ad -> new Xs2aAccountDetails(ad.getResourceId(), ad.getIban(), ad.getBban(), ad.getPan(), ad.getMaskedPan(), ad.getMsisdn(), ad.getCurrency(), ad.getName(), ad.getProduct(), this.mapToAccountType(ad.getCashSpiAccountType()), this.mapToAccountStatus(ad.getSpiAccountStatus()), ad.getBic(), ad.getLinkedAccounts(), this.mapToXs2aUsageType(ad.getUsageType()), ad.getDetails(), this.balanceMapper.mapToXs2aBalanceList(ad.getBalances()))).orElse(null);
    }

    public List<Xs2aAccountDetails> mapToXs2aAccountDetailsList(List<SpiAccountDetails> accountDetails) {
        if (CollectionUtils.isEmpty(accountDetails)) {
            return new ArrayList<Xs2aAccountDetails>();
        }
        return accountDetails.stream().map(this::mapToXs2aAccountDetails).collect(Collectors.toList());
    }

    private CashAccountType mapToAccountType(SpiAccountType spiAccountType) {
        return Optional.ofNullable(spiAccountType).map(type -> CashAccountType.valueOf(type.name())).orElse(null);
    }

    private AccountStatus mapToAccountStatus(SpiAccountStatus spiAccountStatus) {
        return Optional.ofNullable(spiAccountStatus).map(status -> AccountStatus.valueOf(status.name())).orElse(null);
    }

    private Xs2aUsageType mapToXs2aUsageType(SpiUsageType spiUsageType) {
        return Optional.ofNullable(spiUsageType).map(usage -> Xs2aUsageType.valueOf(usage.name())).orElse(null);
    }

    @ConstructorProperties(value={"balanceMapper"})
    public SpiToXs2aAccountDetailsMapper(SpiToXs2aBalanceMapper balanceMapper) {
        this.balanceMapper = balanceMapper;
    }
}

