/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers;

import de.adorsys.psd2.xs2a.domain.MessageErrorCode;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponseStatus;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
public class SpiResponseStatusToXs2aMessageErrorCodeMapper {
    private static final Map<SpiResponseStatus, MessageErrorCode> spiResponseStatusToMessageErrorCode = new HashMap<SpiResponseStatus, MessageErrorCode>();

    public MessageErrorCode mapToMessageErrorCode(SpiResponseStatus responseStatus) {
        return spiResponseStatusToMessageErrorCode.getOrDefault(responseStatus, MessageErrorCode.INTERNAL_SERVER_ERROR);
    }

    static {
        spiResponseStatusToMessageErrorCode.put(SpiResponseStatus.TECHNICAL_FAILURE, MessageErrorCode.INTERNAL_SERVER_ERROR);
        spiResponseStatusToMessageErrorCode.put(SpiResponseStatus.UNAUTHORIZED_FAILURE, MessageErrorCode.UNAUTHORIZED);
        spiResponseStatusToMessageErrorCode.put(SpiResponseStatus.LOGICAL_FAILURE, MessageErrorCode.FORMAT_ERROR);
        spiResponseStatusToMessageErrorCode.put(SpiResponseStatus.NOT_SUPPORTED, MessageErrorCode.PARAMETER_NOT_SUPPORTED);
    }
}

