/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.mapper.consent;

import de.adorsys.psd2.consent.api.AccountInfo;
import de.adorsys.psd2.consent.api.ActionStatus;
import de.adorsys.psd2.consent.api.TypeAccess;
import de.adorsys.psd2.consent.api.ais.AisAccountAccess;
import de.adorsys.psd2.consent.api.ais.AisAccountAccessInfo;
import de.adorsys.psd2.consent.api.ais.AisAccountAccessType;
import de.adorsys.psd2.consent.api.ais.AisAccountConsent;
import de.adorsys.psd2.consent.api.ais.CmsAccountReference;
import de.adorsys.psd2.consent.api.ais.CreateAisConsentRequest;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.domain.MessageErrorCode;
import de.adorsys.psd2.xs2a.domain.account.Xs2aAccountReference;
import de.adorsys.psd2.xs2a.domain.consent.AccountConsent;
import de.adorsys.psd2.xs2a.domain.consent.CreateConsentReq;
import de.adorsys.psd2.xs2a.domain.consent.UpdateConsentPsuDataReq;
import de.adorsys.psd2.xs2a.domain.consent.UpdateConsentPsuDataResponse;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aAccountAccess;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aAuthenticationObject;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aAccountAccessMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aPsuDataMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.Xs2aToSpiAccountAccessMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.Xs2aToSpiPsuDataMapper;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountConsent;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiScaConfirmation;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.Currency;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class Xs2aAisConsentMapper {
    private final SpiToXs2aAccountAccessMapper spiToXs2aAccountAccessMapper;
    private final SpiToXs2aPsuDataMapper spiToXs2aPsuDataMapper;
    private final Xs2aToSpiPsuDataMapper xs2aToSpiPsuDataMapper;
    private final Xs2aToSpiAccountAccessMapper xs2aToSpiAccountAccessMapper;

    public CreateAisConsentRequest mapToCreateAisConsentRequest(CreateConsentReq req, PsuIdData psuData, String tppId, int allowedFrequencyPerDay) {
        return Optional.ofNullable(req).map(r -> {
            CreateAisConsentRequest aisRequest = new CreateAisConsentRequest();
            aisRequest.setPsuData(psuData);
            aisRequest.setTppId(tppId);
            aisRequest.setRequestedFrequencyPerDay(r.getFrequencyPerDay());
            aisRequest.setAllowedFrequencyPerDay(Integer.valueOf(allowedFrequencyPerDay));
            aisRequest.setAccess(this.mapToAisAccountAccessInfo(req.getAccess()));
            aisRequest.setValidUntil(r.getValidUntil());
            aisRequest.setRecurringIndicator(r.isRecurringIndicator());
            aisRequest.setCombinedServiceIndicator(r.isCombinedServiceIndicator());
            return aisRequest;
        }).orElse(null);
    }

    public AccountConsent mapToAccountConsent(SpiAccountConsent spiAccountConsent) {
        return Optional.ofNullable(spiAccountConsent).map(ac -> new AccountConsent(ac.getId(), this.spiToXs2aAccountAccessMapper.mapToAccountAccess(ac.getAccess()), ac.isRecurringIndicator(), ac.getValidUntil(), ac.getFrequencyPerDay(), ac.getLastActionDate(), ac.getConsentStatus(), ac.isWithBalance(), ac.isTppRedirectPreferred(), this.spiToXs2aPsuDataMapper.mapToPsuIdData(ac.getPsuData()), ac.getTppId())).orElse(null);
    }

    public SpiAccountConsent mapToSpiAccountConsent(AccountConsent accountConsent) {
        return Optional.ofNullable(accountConsent).map(ac -> new SpiAccountConsent(ac.getId(), this.xs2aToSpiAccountAccessMapper.mapToAccountAccess(ac.getAccess()), ac.isRecurringIndicator(), ac.getValidUntil(), ac.getFrequencyPerDay(), ac.getLastActionDate(), ac.getConsentStatus(), ac.isWithBalance(), ac.isTppRedirectPreferred(), this.xs2aToSpiPsuDataMapper.mapToSpiPsuData(ac.getPsuData()), ac.getTppId())).orElse(null);
    }

    public ActionStatus mapActionStatusError(MessageErrorCode error, boolean withBalance, TypeAccess access) {
        ActionStatus actionStatus = ActionStatus.FAILURE_ACCOUNT;
        if (error == MessageErrorCode.ACCESS_EXCEEDED) {
            actionStatus = ActionStatus.CONSENT_LIMIT_EXCEEDED;
        } else if (error == MessageErrorCode.CONSENT_EXPIRED) {
            actionStatus = ActionStatus.CONSENT_INVALID_STATUS;
        } else if (error == MessageErrorCode.CONSENT_UNKNOWN_400) {
            actionStatus = ActionStatus.CONSENT_NOT_FOUND;
        } else if (error == MessageErrorCode.CONSENT_INVALID) {
            if (access == TypeAccess.TRANSACTION) {
                actionStatus = ActionStatus.FAILURE_TRANSACTION;
            } else if (access == TypeAccess.BALANCE || withBalance) {
                actionStatus = ActionStatus.FAILURE_BALANCE;
            }
        }
        return actionStatus;
    }

    public UpdateConsentPsuDataReq mapToSpiUpdateConsentPsuDataReq(UpdateConsentPsuDataResponse updatePsuDataResponse, UpdateConsentPsuDataReq updatePsuDataRequest) {
        return Optional.ofNullable(updatePsuDataResponse).map(data -> {
            UpdateConsentPsuDataReq request = new UpdateConsentPsuDataReq();
            request.setPsuData(new PsuIdData(data.getPsuId(), null, null, null));
            request.setConsentId(updatePsuDataRequest.getConsentId());
            request.setAuthorizationId(updatePsuDataRequest.getAuthorizationId());
            request.setAuthenticationMethodId(this.getAuthenticationMethodId((UpdateConsentPsuDataResponse)data));
            request.setScaAuthenticationData(data.getScaAuthenticationData());
            request.setScaStatus(data.getScaStatus());
            return request;
        }).orElse(null);
    }

    private String getAuthenticationMethodId(UpdateConsentPsuDataResponse data) {
        return Optional.ofNullable(data.getChosenScaMethod()).map(Xs2aAuthenticationObject::getAuthenticationMethodId).orElse(null);
    }

    public SpiScaConfirmation mapToSpiScaConfirmation(UpdateConsentPsuDataReq request) {
        SpiScaConfirmation accountConfirmation = new SpiScaConfirmation();
        accountConfirmation.setConsentId(request.getConsentId());
        accountConfirmation.setPsuId((String)Optional.ofNullable(request.getPsuData()).map(PsuIdData::getPsuId).orElse(null));
        accountConfirmation.setTanNumber(request.getScaAuthenticationData());
        return accountConfirmation;
    }

    public AisAccountAccessInfo mapToAisAccountAccessInfo(Xs2aAccountAccess access) {
        AisAccountAccessInfo accessInfo = new AisAccountAccessInfo();
        accessInfo.setAccounts(Optional.ofNullable(access.getAccounts()).map(this::mapToListAccountInfo).orElseGet(Collections::emptyList));
        accessInfo.setBalances(Optional.ofNullable(access.getBalances()).map(this::mapToListAccountInfo).orElseGet(Collections::emptyList));
        accessInfo.setTransactions(Optional.ofNullable(access.getTransactions()).map(this::mapToListAccountInfo).orElseGet(Collections::emptyList));
        accessInfo.setAvailableAccounts((AisAccountAccessType)Optional.ofNullable(access.getAvailableAccounts()).map(accessType -> AisAccountAccessType.valueOf((String)accessType.name())).orElse(null));
        accessInfo.setAllPsd2((AisAccountAccessType)Optional.ofNullable(access.getAllPsd2()).map(accessType -> AisAccountAccessType.valueOf((String)accessType.name())).orElse(null));
        return accessInfo;
    }

    private List<AccountInfo> mapToListAccountInfo(List<Xs2aAccountReference> refs) {
        return refs.stream().map(this::mapToAccountInfo).collect(Collectors.toList());
    }

    private AccountInfo mapToAccountInfo(Xs2aAccountReference ref) {
        AccountInfo info = new AccountInfo();
        info.setResourceId(ref.getResourceId());
        info.setIban(ref.getIban());
        info.setCurrency((String)Optional.ofNullable(ref.getCurrency()).map(Currency::getCurrencyCode).orElse(null));
        return info;
    }

    public AccountConsent mapToAccountConsent(AisAccountConsent ais) {
        return Optional.ofNullable(ais).map(ac -> new AccountConsent(ac.getId(), this.mapToXs2aAccountAccess(ac.getAccess()), ac.isRecurringIndicator(), ac.getValidUntil(), ac.getFrequencyPerDay(), ac.getLastActionDate(), ac.getConsentStatus(), ac.isWithBalance(), ac.isTppRedirectPreferred(), ac.getPsuData(), ac.getTppId())).orElse(null);
    }

    private Xs2aAccountAccess mapToXs2aAccountAccess(AisAccountAccess ais) {
        return new Xs2aAccountAccess(this.mapToXs2aAccountReference(ais.getAccounts()), this.mapToXs2aAccountReference(ais.getBalances()), this.mapToXs2aAccountReference(ais.getTransactions()), null, null);
    }

    private List<Xs2aAccountReference> mapToXs2aAccountReference(List<CmsAccountReference> cms) {
        return cms.stream().map(this::mapToXs2aAccountReference).collect(Collectors.toList());
    }

    private Xs2aAccountReference mapToXs2aAccountReference(CmsAccountReference cms) {
        return new Xs2aAccountReference(cms.getResourceId(), cms.getIban(), cms.getBban(), cms.getPan(), cms.getMaskedPan(), cms.getMsisdn(), cms.getCurrency());
    }

    @ConstructorProperties(value={"spiToXs2aAccountAccessMapper", "spiToXs2aPsuDataMapper", "xs2aToSpiPsuDataMapper", "xs2aToSpiAccountAccessMapper"})
    public Xs2aAisConsentMapper(SpiToXs2aAccountAccessMapper spiToXs2aAccountAccessMapper, SpiToXs2aPsuDataMapper spiToXs2aPsuDataMapper, Xs2aToSpiPsuDataMapper xs2aToSpiPsuDataMapper, Xs2aToSpiAccountAccessMapper xs2aToSpiAccountAccessMapper) {
        this.spiToXs2aAccountAccessMapper = spiToXs2aAccountAccessMapper;
        this.spiToXs2aPsuDataMapper = spiToXs2aPsuDataMapper;
        this.xs2aToSpiPsuDataMapper = xs2aToSpiPsuDataMapper;
        this.xs2aToSpiAccountAccessMapper = xs2aToSpiAccountAccessMapper;
    }
}

