/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.mapper;

import de.adorsys.psd2.xs2a.domain.ResponseObject;
import de.adorsys.psd2.xs2a.exception.MessageError;
import de.adorsys.psd2.xs2a.service.mapper.MessageErrorMapper;
import java.beans.ConstructorProperties;
import java.util.function.Function;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
public class ResponseMapper {
    private final MessageErrorMapper messageErrorMapper;

    public <T, R> ResponseEntity<?> ok(ResponseObject<T> response, Function<T, R> mapper) {
        return this.getEntity(response, HttpStatus.OK, mapper);
    }

    public <T, R> ResponseEntity<?> created(ResponseObject<T> response, Function<T, R> mapper) {
        return this.getEntity(response, HttpStatus.CREATED, mapper);
    }

    public <T, R> ResponseEntity<?> delete(ResponseObject<T> response, Function<T, R> mapper) {
        return this.getEntity(response, HttpStatus.NO_CONTENT, mapper);
    }

    public <T> ResponseEntity<T> ok(ResponseObject<T> response) {
        return this.getEntity(response, HttpStatus.OK);
    }

    public <T> ResponseEntity<T> created(ResponseObject<T> response) {
        return this.getEntity(response, HttpStatus.CREATED);
    }

    public <T> ResponseEntity<T> delete(ResponseObject<T> response) {
        return this.getEntity(response, HttpStatus.NO_CONTENT);
    }

    public <T> ResponseEntity<T> accepted(ResponseObject<T> response) {
        return this.getEntity(response, HttpStatus.ACCEPTED);
    }

    private <T> ResponseEntity<T> getEntity(ResponseObject<T> response, HttpStatus status) {
        return this.getEntity(response, status, null);
    }

    private <T, R> ResponseEntity getEntity(ResponseObject<T> response, HttpStatus status, Function<T, R> mapper) {
        T body = response.getBody();
        return response.hasError() ? this.createErrorResponse(response.getError()) : new ResponseEntity(this.getBody(body, mapper), status);
    }

    private <T, R> Object getBody(T body, Function<T, R> mapper) {
        return mapper == null ? body : mapper.apply(body);
    }

    private ResponseEntity createErrorResponse(MessageError error) {
        return new ResponseEntity((Object)this.messageErrorMapper.mapToTppMessages(error), HttpStatus.valueOf((int)error.getTppMessage().getMessageErrorCode().getCode()));
    }

    @ConstructorProperties(value={"messageErrorMapper"})
    public ResponseMapper(MessageErrorMapper messageErrorMapper) {
        this.messageErrorMapper = messageErrorMapper;
    }
}

