/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.mapper;

import de.adorsys.psd2.model.TppMessageCategory;
import de.adorsys.psd2.model.TppMessageGeneric;
import de.adorsys.psd2.model.TppMessages;
import de.adorsys.psd2.xs2a.domain.MessageErrorCode;
import de.adorsys.psd2.xs2a.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.exception.MessageError;
import de.adorsys.psd2.xs2a.service.message.MessageService;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.springframework.stereotype.Component;

@Component
public class MessageErrorMapper {
    private final MessageService messageService;

    public TppMessages mapToTppMessages(MessageErrorCode ... errorCodes) {
        return Optional.ofNullable(errorCodes).map(m -> Arrays.stream(m).map(str -> this.mapToGenericError((MessageErrorCode)((Object)((Object)str)), "N/A")).collect(Collectors.toList())).map(this::mapTppMessageGenericListToTppMessages).orElseGet(TppMessages::new);
    }

    public TppMessages mapToTppMessages(MessageError error) {
        return Optional.ofNullable(error).map(MessageError::getTppMessages).map(e -> e.stream().map(this::mapToGenericError).collect(Collectors.toList())).map(this::mapTppMessageGenericListToTppMessages).orElseGet(TppMessages::new);
    }

    private TppMessages mapTppMessageGenericListToTppMessages(@NonNull List<TppMessageGeneric> messageGenericList) {
        if (messageGenericList == null) {
            throw new NullPointerException("messageGenericList");
        }
        return messageGenericList.stream().collect(Collectors.toCollection(TppMessages::new));
    }

    private TppMessageGeneric mapToGenericError(@NonNull TppMessageInformation info) {
        if (info == null) {
            throw new NullPointerException("info");
        }
        return this.mapToGenericError(info.getMessageErrorCode(), info.getPath());
    }

    private TppMessageGeneric mapToGenericError(@NonNull MessageErrorCode code, String path) {
        if (code == null) {
            throw new NullPointerException("code");
        }
        TppMessageGeneric tppMessage = new TppMessageGeneric();
        tppMessage.setCategory(TppMessageCategory.ERROR);
        tppMessage.setCode((Object)code);
        tppMessage.setPath(path);
        tppMessage.setText(this.messageService.getMessage(code.name()));
        return tppMessage;
    }

    @ConstructorProperties(value={"messageService"})
    public MessageErrorMapper(MessageService messageService) {
        this.messageService = messageService;
    }
}

