/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.mapper;

import de.adorsys.psd2.model.Amount;
import de.adorsys.psd2.xs2a.domain.Xs2aAmount;
import java.util.Currency;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class AmountModelMapper {
    public static Xs2aAmount mapToXs2aAmount(Amount amount) {
        return Optional.ofNullable(amount).map(a -> {
            Xs2aAmount amountTarget = new Xs2aAmount();
            amountTarget.setAmount(a.getAmount());
            amountTarget.setCurrency(AmountModelMapper.getCurrencyByCode(a.getCurrency()));
            return amountTarget;
        }).orElse(null);
    }

    public static Amount mapToAmount(Xs2aAmount amount) {
        return Optional.ofNullable(amount).map(a -> {
            Amount amountTarget = new Amount();
            amountTarget.setAmount(a.getAmount());
            amountTarget.setCurrency(a.getCurrency().getCurrencyCode());
            return amountTarget;
        }).orElse(null);
    }

    private static Currency getCurrencyByCode(String code) {
        return StringUtils.isNotBlank((CharSequence)code) ? Currency.getInstance(code) : null;
    }
}

