/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.mapper;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.adorsys.psd2.model.AccountDetails;
import de.adorsys.psd2.model.AccountList;
import de.adorsys.psd2.model.AccountReferenceBban;
import de.adorsys.psd2.model.AccountReferenceIban;
import de.adorsys.psd2.model.AccountReferenceMaskedPan;
import de.adorsys.psd2.model.AccountReferenceMsisdn;
import de.adorsys.psd2.model.AccountReferencePan;
import de.adorsys.psd2.model.AccountReport;
import de.adorsys.psd2.model.AccountStatus;
import de.adorsys.psd2.model.Address;
import de.adorsys.psd2.model.Amount;
import de.adorsys.psd2.model.Balance;
import de.adorsys.psd2.model.BalanceList;
import de.adorsys.psd2.model.BalanceType;
import de.adorsys.psd2.model.PurposeCode;
import de.adorsys.psd2.model.ReadBalanceResponse200;
import de.adorsys.psd2.model.TransactionDetails;
import de.adorsys.psd2.model.TransactionList;
import de.adorsys.psd2.model.TransactionsResponse200Json;
import de.adorsys.psd2.xs2a.domain.Transactions;
import de.adorsys.psd2.xs2a.domain.Xs2aAmount;
import de.adorsys.psd2.xs2a.domain.Xs2aBalance;
import de.adorsys.psd2.xs2a.domain.account.Xs2aAccountDetails;
import de.adorsys.psd2.xs2a.domain.account.Xs2aAccountReference;
import de.adorsys.psd2.xs2a.domain.account.Xs2aAccountReport;
import de.adorsys.psd2.xs2a.domain.account.Xs2aBalancesReport;
import de.adorsys.psd2.xs2a.domain.account.Xs2aTransactionsReport;
import de.adorsys.psd2.xs2a.domain.account.Xs2aUsageType;
import de.adorsys.psd2.xs2a.domain.address.Xs2aAddress;
import de.adorsys.psd2.xs2a.domain.address.Xs2aCountryCode;
import de.adorsys.psd2.xs2a.domain.code.Xs2aPurposeCode;
import de.adorsys.psd2.xs2a.service.mapper.AmountModelMapper;
import java.beans.ConstructorProperties;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Currency;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Component;

@Component
public class AccountModelMapper {
    private static final Logger log = LoggerFactory.getLogger(AccountModelMapper.class);
    private final ObjectMapper objectMapper;

    public AccountList mapToAccountList(Map<String, List<Xs2aAccountDetails>> accountDetailsList) {
        List details = accountDetailsList.values().stream().flatMap(ad -> ad.stream().map(this::mapToAccountDetails)).collect(Collectors.toList());
        return new AccountList().accounts(details);
    }

    public AccountDetails mapToAccountDetails(Xs2aAccountDetails accountDetails) {
        AccountDetails target = new AccountDetails();
        BeanUtils.copyProperties((Object)accountDetails, (Object)target);
        target.resourceId(accountDetails.getResourceId()).currency(accountDetails.getCurrency().getCurrencyCode()).cashAccountType((String)Optional.ofNullable(accountDetails.getCashAccountType()).map(Enum::name).orElse(null)).usage(this.mapToAccountDetailsUsageEnum(accountDetails.getUsageType())).status(this.mapToAccountStatus(accountDetails.getAccountStatus()));
        return target.balances(this.mapToBalanceList(accountDetails.getBalances()))._links((Map)this.objectMapper.convertValue((Object)accountDetails.getLinks(), Map.class));
    }

    private BalanceList mapToBalanceList(List<Xs2aBalance> balances) {
        BalanceList balanceList = null;
        if (CollectionUtils.isNotEmpty(balances)) {
            balanceList = new BalanceList();
            balanceList.addAll((Collection)balances.stream().map(this::mapToBalance).collect(Collectors.toList()));
        }
        return balanceList;
    }

    private AccountDetails.UsageEnum mapToAccountDetailsUsageEnum(Xs2aUsageType usageType) {
        return Optional.ofNullable(usageType).map(Xs2aUsageType::getValue).map(AccountDetails.UsageEnum::fromValue).orElse(null);
    }

    private AccountStatus mapToAccountStatus(de.adorsys.psd2.xs2a.domain.account.AccountStatus accountStatus) {
        return Optional.ofNullable(accountStatus).map(de.adorsys.psd2.xs2a.domain.account.AccountStatus::getValue).map(AccountStatus::fromValue).orElse(null);
    }

    public ReadBalanceResponse200 mapToBalance(Xs2aBalancesReport balancesReport) {
        BalanceList balanceList = new BalanceList();
        balancesReport.getBalances().forEach(balance -> balanceList.add((Object)this.mapToBalance((Xs2aBalance)balance)));
        return new ReadBalanceResponse200().balances(balanceList).account((Object)balancesReport.getXs2aAccountReference());
    }

    public Balance mapToBalance(Xs2aBalance balance) {
        Balance target = new Balance();
        BeanUtils.copyProperties((Object)balance, (Object)target);
        target.setBalanceAmount(AmountModelMapper.mapToAmount(balance.getBalanceAmount()));
        Optional.ofNullable(balance.getBalanceType()).ifPresent(balanceType -> target.setBalanceType(BalanceType.fromValue((String)balanceType.getValue())));
        Optional.ofNullable(balance.getLastChangeDateTime()).ifPresent(lastChangeDateTime -> {
            List<ZoneOffset> validOffsets = ZoneId.systemDefault().getRules().getValidOffsets((LocalDateTime)lastChangeDateTime);
            target.setLastChangeDateTime(lastChangeDateTime.atOffset(validOffsets.get(0)));
        });
        return target;
    }

    public AccountReport mapToAccountReport(Xs2aAccountReport accountReport) {
        TransactionList booked = new TransactionList();
        List bookedTransactions = Optional.ofNullable(accountReport.getBooked()).map(ts -> ts.stream().map(this::mapToTransaction).collect(Collectors.toList())).orElseGet(ArrayList::new);
        booked.addAll((Collection)bookedTransactions);
        TransactionList pending = new TransactionList();
        List pendingTransactions = Optional.ofNullable(accountReport.getPending()).map(ts -> ts.stream().map(this::mapToTransaction).collect(Collectors.toList())).orElseGet(ArrayList::new);
        pending.addAll((Collection)pendingTransactions);
        return new AccountReport().booked(booked).pending(pending)._links((Map)this.objectMapper.convertValue((Object)accountReport.getLinks(), Map.class));
    }

    public TransactionDetails mapToTransaction(Transactions transactions) {
        TransactionDetails target = new TransactionDetails();
        BeanUtils.copyProperties((Object)transactions, (Object)target);
        target.setCreditorAccount(this.createAccountObject(transactions.getCreditorAccount()));
        target.setDebtorAccount(this.createAccountObject(transactions.getDebtorAccount()));
        Optional.ofNullable(transactions.getAmount()).ifPresent(amount -> target.setTransactionAmount(AmountModelMapper.mapToAmount(amount)));
        target.setPurposeCode(PurposeCode.fromValue((String)Optional.ofNullable(transactions.getPurposeCode()).map(Xs2aPurposeCode::getCode).orElse(null)));
        Optional.ofNullable(transactions.getBankTransactionCodeCode()).ifPresent(transactionCode -> target.setBankTransactionCode(transactionCode.getCode()));
        return target;
    }

    public <T> T mapToAccountReference12(Xs2aAccountReference reference) {
        if (reference == null) {
            return null;
        }
        AccountReferenceIban accountReference = null;
        String currency = Optional.ofNullable(reference.getCurrency()).map(Currency::getCurrencyCode).orElse(null);
        if (StringUtils.isNotBlank((CharSequence)reference.getIban())) {
            accountReference = new AccountReferenceIban().iban(reference.getIban()).currency(currency);
        } else if (StringUtils.isNotBlank((CharSequence)reference.getBban())) {
            accountReference = new AccountReferenceBban().bban(reference.getBban()).currency(currency);
        } else if (StringUtils.isNotBlank((CharSequence)reference.getPan())) {
            accountReference = new AccountReferencePan().pan(reference.getPan()).currency(currency);
        } else if (StringUtils.isNotBlank((CharSequence)reference.getMaskedPan())) {
            accountReference = new AccountReferenceMaskedPan().maskedPan(reference.getMaskedPan()).currency(currency);
        } else if (StringUtils.isNotBlank((CharSequence)reference.getMsisdn())) {
            accountReference = new AccountReferenceMsisdn().msisdn(reference.getMsisdn()).currency(currency);
        }
        return (T)accountReference;
    }

    public Address mapToAddress12(Xs2aAddress address) {
        Address targetAddress = new Address().street(address.getStreet());
        targetAddress.setStreet(address.getStreet());
        targetAddress.setBuildingNumber(address.getBuildingNumber());
        targetAddress.setCity(address.getCity());
        targetAddress.setPostalCode(address.getPostalCode());
        targetAddress.setCountry((String)Optional.ofNullable(address.getCountry()).map(Xs2aCountryCode::getCode).orElse(null));
        return targetAddress;
    }

    public Xs2aAddress mapToXs2aAddress(Address address) {
        return Optional.ofNullable(address).map(a -> {
            Xs2aAddress targetAddress = new Xs2aAddress();
            targetAddress.setStreet(a.getStreet());
            targetAddress.setBuildingNumber(a.getBuildingNumber());
            targetAddress.setCity(a.getCity());
            targetAddress.setPostalCode(a.getPostalCode());
            targetAddress.setCountry(new Xs2aCountryCode(a.getCountry()));
            return targetAddress;
        }).orElseGet(Xs2aAddress::new);
    }

    public Xs2aAmount mapToXs2aAmount(Amount amount) {
        return Optional.ofNullable(amount).map(a -> {
            Xs2aAmount targetAmount = new Xs2aAmount();
            targetAmount.setAmount(a.getAmount());
            targetAmount.setCurrency(Currency.getInstance(a.getCurrency()));
            return targetAmount;
        }).orElseGet(Xs2aAmount::new);
    }

    public TransactionsResponse200Json mapToTransactionsResponse200Json(Xs2aTransactionsReport transactionsReport) {
        TransactionsResponse200Json transactionsResponse200Json = new TransactionsResponse200Json();
        transactionsResponse200Json.setTransactions(this.mapToAccountReport(transactionsReport.getAccountReport()));
        transactionsResponse200Json.setBalances(this.mapToBalanceList(transactionsReport.getBalances()));
        transactionsResponse200Json.setAccount(this.mapToAccountReference12(transactionsReport.getXs2aAccountReference()));
        transactionsResponse200Json.setLinks((Map)this.objectMapper.convertValue((Object)transactionsReport.getLinks(), Map.class));
        return transactionsResponse200Json;
    }

    private Object createAccountObject(Xs2aAccountReference xs2aAccountReference) {
        return Optional.ofNullable(xs2aAccountReference).map(account -> {
            if (account.getIban() != null) {
                return new AccountReferenceIban().iban(account.getIban()).currency(this.getCurrencyFromAccountReference((Xs2aAccountReference)account));
            }
            if (account.getBban() != null) {
                return new AccountReferenceBban().bban(account.getBban()).currency(this.getCurrencyFromAccountReference((Xs2aAccountReference)account));
            }
            if (account.getPan() != null) {
                return new AccountReferencePan().pan(account.getPan()).currency(this.getCurrencyFromAccountReference((Xs2aAccountReference)account));
            }
            if (account.getMsisdn() != null) {
                return new AccountReferenceMsisdn().msisdn(account.getMsisdn()).currency(this.getCurrencyFromAccountReference((Xs2aAccountReference)account));
            }
            if (account.getMaskedPan() != null) {
                return new AccountReferenceMaskedPan().maskedPan(account.getMaskedPan()).currency(this.getCurrencyFromAccountReference((Xs2aAccountReference)account));
            }
            return null;
        }).orElse(null);
    }

    private String getCurrencyFromAccountReference(Xs2aAccountReference xs2aAccountReference) {
        return Optional.ofNullable(xs2aAccountReference.getCurrency()).map(Currency::getCurrencyCode).orElse(null);
    }

    @ConstructorProperties(value={"objectMapper"})
    public AccountModelMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }
}

