/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.event;

import de.adorsys.psd2.consent.api.service.EventService;
import de.adorsys.psd2.xs2a.core.event.Event;
import de.adorsys.psd2.xs2a.core.event.EventOrigin;
import de.adorsys.psd2.xs2a.core.event.EventType;
import de.adorsys.psd2.xs2a.domain.RequestData;
import de.adorsys.psd2.xs2a.domain.event.RequestEventPayload;
import de.adorsys.psd2.xs2a.service.RequestProviderService;
import de.adorsys.psd2.xs2a.service.TppService;
import java.beans.ConstructorProperties;
import java.time.OffsetDateTime;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class Xs2aEventService {
    private static final Logger log = LoggerFactory.getLogger(Xs2aEventService.class);
    private final TppService tppService;
    private final EventService eventService;
    private final RequestProviderService requestProviderService;

    public void recordAisTppRequest(@NotNull String consentId, @NotNull EventType eventType) {
        this.recordAisTppRequest(consentId, eventType, null);
    }

    public void recordAisTppRequest(@NotNull String consentId, @NotNull EventType eventType, @Nullable Object body) {
        Event event = this.buildTppEvent(eventType, body);
        event.setConsentId(consentId);
        this.recordEventInCms(event);
    }

    public void recordPisTppRequest(@NotNull String paymentId, @NotNull EventType eventType) {
        this.recordPisTppRequest(paymentId, eventType, null);
    }

    public void recordPisTppRequest(@NotNull String paymentId, @NotNull EventType eventType, @Nullable Object body) {
        Event event = this.buildTppEvent(eventType, body);
        event.setPaymentId(paymentId);
        this.recordEventInCms(event);
    }

    public void recordTppRequest(@NotNull EventType eventType) {
        this.recordTppRequest(eventType, null);
    }

    public void recordTppRequest(@NotNull EventType eventType, @Nullable Object body) {
        Event event = this.buildTppEvent(eventType, body);
        this.recordEventInCms(event);
    }

    private void recordEventInCms(Event event) {
        boolean recorded = this.eventService.recordEvent(event);
        if (!recorded) {
            log.error("Couldn't record event from TPP request: {}", (Object)event);
        }
    }

    private Event buildTppEvent(EventType eventType, Object body) {
        Event event = new Event();
        event.setTimestamp(OffsetDateTime.now());
        event.setEventOrigin(EventOrigin.TPP);
        event.setEventType(eventType);
        RequestEventPayload payload = this.buildRequestEventPayload(body);
        event.setPayload((Object)payload);
        return event;
    }

    private RequestEventPayload buildRequestEventPayload(Object body) {
        RequestData requestData = this.requestProviderService.getRequestData();
        RequestEventPayload requestPayload = new RequestEventPayload();
        requestPayload.setTppInfo(this.tppService.getTppInfo());
        requestPayload.setTppIp(requestData.getIp());
        requestPayload.setRequestId(requestData.getRequestId());
        requestPayload.setUri(requestData.getUri());
        requestPayload.setHeaders(requestData.getHeaders());
        requestPayload.setBody(body);
        return requestPayload;
    }

    @ConstructorProperties(value={"tppService", "eventService", "requestProviderService"})
    public Xs2aEventService(TppService tppService, EventService eventService, RequestProviderService requestProviderService) {
        this.tppService = tppService;
        this.eventService = eventService;
        this.requestProviderService = requestProviderService;
    }
}

