/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.consent;

import de.adorsys.psd2.consent.api.pis.proto.CreatePisConsentResponse;
import de.adorsys.psd2.consent.api.pis.proto.PisConsentRequest;
import de.adorsys.psd2.consent.api.pis.proto.PisConsentResponse;
import de.adorsys.psd2.consent.api.service.PisConsentService;
import de.adorsys.psd2.xs2a.core.consent.ConsentStatus;
import de.adorsys.psd2.xs2a.core.tpp.TppInfo;
import de.adorsys.psd2.xs2a.domain.pis.BulkPayment;
import de.adorsys.psd2.xs2a.domain.pis.PaymentInitiationParameters;
import de.adorsys.psd2.xs2a.domain.pis.PeriodicPayment;
import de.adorsys.psd2.xs2a.domain.pis.SinglePayment;
import de.adorsys.psd2.xs2a.service.mapper.consent.Xs2aPisConsentMapper;
import de.adorsys.psd2.xs2a.service.mapper.consent.Xs2aToCmsPisConsentRequest;
import java.beans.ConstructorProperties;
import java.util.Optional;
import org.springframework.stereotype.Service;

@Service
public class Xs2aPisConsentService {
    private final PisConsentService pisConsentService;
    private final Xs2aPisConsentMapper pisConsentMapper;
    private final Xs2aToCmsPisConsentRequest xs2aToCmsPisConsentRequest;

    public CreatePisConsentResponse createPisConsent(PaymentInitiationParameters parameters, TppInfo tppInfo) {
        PisConsentRequest request = new PisConsentRequest();
        request.setTppInfo(tppInfo);
        request.setPaymentProduct(parameters.getPaymentProduct());
        request.setPaymentType(parameters.getPaymentType());
        request.setPsuData(parameters.getPsuData());
        return this.pisConsentService.createPaymentConsent(request).orElse(null);
    }

    public Optional<PisConsentResponse> getPisConsentById(String consentId) {
        return this.pisConsentService.getConsentById(consentId);
    }

    public void updateSinglePaymentInPisConsent(SinglePayment singlePayment, PaymentInitiationParameters paymentInitiationParameters, String consentId) {
        PisConsentRequest pisConsentRequest = this.xs2aToCmsPisConsentRequest.mapToCmsSinglePisConsentRequest(singlePayment, paymentInitiationParameters.getPaymentProduct());
        this.pisConsentService.updatePaymentConsent(pisConsentRequest, consentId);
    }

    public void updatePeriodicPaymentInPisConsent(PeriodicPayment periodicPayment, PaymentInitiationParameters paymentInitiationParameters, String consentId) {
        PisConsentRequest pisConsentRequest = this.xs2aToCmsPisConsentRequest.mapToCmsPeriodicPisConsentRequest(periodicPayment, paymentInitiationParameters.getPaymentProduct());
        this.pisConsentService.updatePaymentConsent(pisConsentRequest, consentId);
    }

    public void updateBulkPaymentInPisConsent(BulkPayment bulkPayment, PaymentInitiationParameters paymentInitiationParameters, String consentId) {
        PisConsentRequest pisConsentRequest = this.xs2aToCmsPisConsentRequest.mapToCmsBulkPisConsentRequest(bulkPayment, paymentInitiationParameters.getPaymentProduct());
        this.pisConsentService.updatePaymentConsent(pisConsentRequest, consentId);
    }

    public Optional<Boolean> revokeConsentById(String consentId) {
        return this.pisConsentService.updateConsentStatusById(consentId, ConsentStatus.REVOKED_BY_PSU);
    }

    @ConstructorProperties(value={"pisConsentService", "pisConsentMapper", "xs2aToCmsPisConsentRequest"})
    public Xs2aPisConsentService(PisConsentService pisConsentService, Xs2aPisConsentMapper pisConsentMapper, Xs2aToCmsPisConsentRequest xs2aToCmsPisConsentRequest) {
        this.pisConsentService = pisConsentService;
        this.pisConsentMapper = pisConsentMapper;
        this.xs2aToCmsPisConsentRequest = xs2aToCmsPisConsentRequest;
    }
}

