/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.consent;

import de.adorsys.psd2.consent.api.AspspDataService;
import de.adorsys.psd2.consent.api.service.PisConsentService;
import de.adorsys.psd2.xs2a.core.consent.AspspConsentData;
import java.beans.ConstructorProperties;
import org.springframework.stereotype.Service;

@Service
public class PisConsentDataService {
    private final PisConsentService pisConsentService;
    private final AspspDataService aspspDataService;

    public AspspConsentData getAspspConsentData(String paymentId) {
        return this.aspspDataService.readAspspConsentData(paymentId).orElseGet(() -> new AspspConsentData(null, paymentId));
    }

    public void updateAspspConsentData(AspspConsentData consentData) {
        this.aspspDataService.updateAspspConsentData(consentData);
    }

    public String getInternalPaymentIdByEncryptedString(String encryptedId) {
        return this.pisConsentService.getDecryptedId(encryptedId).orElse(null);
    }

    @ConstructorProperties(value={"pisConsentService", "aspspDataService"})
    public PisConsentDataService(PisConsentService pisConsentService, AspspDataService aspspDataService) {
        this.pisConsentService = pisConsentService;
        this.aspspDataService = aspspDataService;
    }
}

