/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.authorization.pis.stage;

import de.adorsys.psd2.consent.api.pis.PisPayment;
import de.adorsys.psd2.consent.api.service.PisConsentService;
import de.adorsys.psd2.xs2a.core.profile.PaymentProduct;
import de.adorsys.psd2.xs2a.core.profile.PaymentType;
import de.adorsys.psd2.xs2a.domain.pis.BulkPayment;
import de.adorsys.psd2.xs2a.domain.pis.PeriodicPayment;
import de.adorsys.psd2.xs2a.domain.pis.SinglePayment;
import de.adorsys.psd2.xs2a.service.consent.PisConsentDataService;
import de.adorsys.psd2.xs2a.service.mapper.consent.CmsToXs2aPaymentMapper;
import de.adorsys.psd2.xs2a.service.mapper.consent.Xs2aPisConsentMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiErrorMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aAuthenticationObjectMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.Xs2aToSpiBulkPaymentMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.Xs2aToSpiPeriodicPaymentMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.Xs2aToSpiPsuDataMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.Xs2aToSpiSinglePaymentMapper;
import de.adorsys.psd2.xs2a.spi.service.BulkPaymentSpi;
import de.adorsys.psd2.xs2a.spi.service.PaymentAuthorisationSpi;
import de.adorsys.psd2.xs2a.spi.service.PaymentCancellationSpi;
import de.adorsys.psd2.xs2a.spi.service.PaymentSpi;
import de.adorsys.psd2.xs2a.spi.service.PeriodicPaymentSpi;
import de.adorsys.psd2.xs2a.spi.service.SinglePaymentSpi;
import de.adorsys.psd2.xs2a.spi.service.SpiPayment;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.function.BiFunction;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

public abstract class PisScaStage<T, U, R>
implements BiFunction<T, U, R> {
    protected final PaymentAuthorisationSpi paymentAuthorisationSpi;
    protected final PaymentCancellationSpi paymentCancellationSpi;
    protected final PisConsentDataService pisConsentDataService;
    protected final PisConsentService pisConsentService;
    protected final CmsToXs2aPaymentMapper cmsToXs2aPaymentMapper;
    protected final Xs2aToSpiPeriodicPaymentMapper xs2aToSpiPeriodicPaymentMapper;
    protected final Xs2aToSpiSinglePaymentMapper xs2aToSpiSinglePaymentMapper;
    protected final Xs2aToSpiBulkPaymentMapper xs2aToSpiBulkPaymentMapper;
    protected final SpiToXs2aAuthenticationObjectMapper spiToXs2aAuthenticationObjectMapper;
    protected final Xs2aPisConsentMapper xs2aPisConsentMapper;
    protected final SpiErrorMapper spiErrorMapper;
    protected final Xs2aToSpiPsuDataMapper xs2aToSpiPsuDataMapper;
    @Autowired
    private ApplicationContext applicationContext;

    protected PaymentSpi getPaymentService(PaymentType paymentType) {
        if (PaymentType.SINGLE == paymentType) {
            return (PaymentSpi)this.applicationContext.getBean(SinglePaymentSpi.class);
        }
        if (PaymentType.PERIODIC == paymentType) {
            return (PaymentSpi)this.applicationContext.getBean(PeriodicPaymentSpi.class);
        }
        return (PaymentSpi)this.applicationContext.getBean(BulkPaymentSpi.class);
    }

    protected SpiPayment mapToSpiPayment(List<PisPayment> payments, PaymentType paymentType) {
        if (PaymentType.SINGLE == paymentType) {
            SinglePayment singlePayment = this.cmsToXs2aPaymentMapper.mapToSinglePayment(payments.get(0));
            return this.xs2aToSpiSinglePaymentMapper.mapToSpiSinglePayment(singlePayment, PaymentProduct.SEPA);
        }
        if (PaymentType.PERIODIC == paymentType) {
            PeriodicPayment periodicPayment = this.cmsToXs2aPaymentMapper.mapToPeriodicPayment(payments.get(0));
            return this.xs2aToSpiPeriodicPaymentMapper.mapToSpiPeriodicPayment(periodicPayment, PaymentProduct.SEPA);
        }
        BulkPayment bulkPayment = this.cmsToXs2aPaymentMapper.mapToBulkPayment(payments);
        return this.xs2aToSpiBulkPaymentMapper.mapToSpiBulkPayment(bulkPayment, PaymentProduct.SEPA);
    }

    @ConstructorProperties(value={"paymentAuthorisationSpi", "paymentCancellationSpi", "pisConsentDataService", "pisConsentService", "cmsToXs2aPaymentMapper", "xs2aToSpiPeriodicPaymentMapper", "xs2aToSpiSinglePaymentMapper", "xs2aToSpiBulkPaymentMapper", "spiToXs2aAuthenticationObjectMapper", "xs2aPisConsentMapper", "spiErrorMapper", "xs2aToSpiPsuDataMapper"})
    public PisScaStage(PaymentAuthorisationSpi paymentAuthorisationSpi, PaymentCancellationSpi paymentCancellationSpi, PisConsentDataService pisConsentDataService, PisConsentService pisConsentService, CmsToXs2aPaymentMapper cmsToXs2aPaymentMapper, Xs2aToSpiPeriodicPaymentMapper xs2aToSpiPeriodicPaymentMapper, Xs2aToSpiSinglePaymentMapper xs2aToSpiSinglePaymentMapper, Xs2aToSpiBulkPaymentMapper xs2aToSpiBulkPaymentMapper, SpiToXs2aAuthenticationObjectMapper spiToXs2aAuthenticationObjectMapper, Xs2aPisConsentMapper xs2aPisConsentMapper, SpiErrorMapper spiErrorMapper, Xs2aToSpiPsuDataMapper xs2aToSpiPsuDataMapper) {
        this.paymentAuthorisationSpi = paymentAuthorisationSpi;
        this.paymentCancellationSpi = paymentCancellationSpi;
        this.pisConsentDataService = pisConsentDataService;
        this.pisConsentService = pisConsentService;
        this.cmsToXs2aPaymentMapper = cmsToXs2aPaymentMapper;
        this.xs2aToSpiPeriodicPaymentMapper = xs2aToSpiPeriodicPaymentMapper;
        this.xs2aToSpiSinglePaymentMapper = xs2aToSpiSinglePaymentMapper;
        this.xs2aToSpiBulkPaymentMapper = xs2aToSpiBulkPaymentMapper;
        this.spiToXs2aAuthenticationObjectMapper = spiToXs2aAuthenticationObjectMapper;
        this.xs2aPisConsentMapper = xs2aPisConsentMapper;
        this.spiErrorMapper = spiErrorMapper;
        this.xs2aToSpiPsuDataMapper = xs2aToSpiPsuDataMapper;
    }
}

