/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.authorization.pis.stage;

import de.adorsys.psd2.consent.api.pis.authorisation.GetPisConsentAuthorisationResponse;
import de.adorsys.psd2.consent.api.service.PisConsentService;
import de.adorsys.psd2.xs2a.core.consent.AspspConsentData;
import de.adorsys.psd2.xs2a.core.consent.ConsentStatus;
import de.adorsys.psd2.xs2a.core.profile.PaymentType;
import de.adorsys.psd2.xs2a.core.sca.ChallengeData;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import de.adorsys.psd2.xs2a.domain.consent.pis.Xs2aUpdatePisConsentPsuDataRequest;
import de.adorsys.psd2.xs2a.domain.consent.pis.Xs2aUpdatePisConsentPsuDataResponse;
import de.adorsys.psd2.xs2a.service.authorization.pis.stage.PisScaStage;
import de.adorsys.psd2.xs2a.service.consent.PisConsentDataService;
import de.adorsys.psd2.xs2a.service.mapper.consent.CmsToXs2aPaymentMapper;
import de.adorsys.psd2.xs2a.service.mapper.consent.Xs2aPisConsentMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiErrorMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aAuthenticationObjectMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.Xs2aToSpiBulkPaymentMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.Xs2aToSpiPeriodicPaymentMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.Xs2aToSpiPsuDataMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.Xs2aToSpiSinglePaymentMapper;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiAuthenticationObject;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiAuthorizationCodeResult;
import de.adorsys.psd2.xs2a.spi.domain.psu.SpiPsuData;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import de.adorsys.psd2.xs2a.spi.service.PaymentAuthorisationSpi;
import de.adorsys.psd2.xs2a.spi.service.PaymentCancellationSpi;
import de.adorsys.psd2.xs2a.spi.service.SpiPayment;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

@Service(value="PIS_CANC_STARTED")
public class PisCancellationScaStartAuthorisationStage
extends PisScaStage<Xs2aUpdatePisConsentPsuDataRequest, GetPisConsentAuthorisationResponse, Xs2aUpdatePisConsentPsuDataResponse> {
    public PisCancellationScaStartAuthorisationStage(PaymentAuthorisationSpi paymentAuthorisationSpi, PaymentCancellationSpi paymentCancellationSpi, PisConsentDataService pisConsentDataService, PisConsentService pisConsentService, CmsToXs2aPaymentMapper cmsToXs2aPaymentMapper, Xs2aToSpiPeriodicPaymentMapper xs2aToSpiPeriodicPaymentMapper, Xs2aToSpiSinglePaymentMapper xs2aToSpiSinglePaymentMapper, Xs2aToSpiBulkPaymentMapper xs2aToSpiBulkPaymentMapper, SpiToXs2aAuthenticationObjectMapper spiToXs2aAuthenticationObjectMapper, Xs2aPisConsentMapper xs2aPisConsentMapper, SpiErrorMapper spiErrorMapper, Xs2aToSpiPsuDataMapper xs2aToSpiPsuDataMapper) {
        super(paymentAuthorisationSpi, paymentCancellationSpi, pisConsentDataService, pisConsentService, cmsToXs2aPaymentMapper, xs2aToSpiPeriodicPaymentMapper, xs2aToSpiSinglePaymentMapper, xs2aToSpiBulkPaymentMapper, spiToXs2aAuthenticationObjectMapper, xs2aPisConsentMapper, spiErrorMapper, xs2aToSpiPsuDataMapper);
    }

    @Override
    public Xs2aUpdatePisConsentPsuDataResponse apply(Xs2aUpdatePisConsentPsuDataRequest request, GetPisConsentAuthorisationResponse pisConsentAuthorisationResponse) {
        PaymentType paymentType = pisConsentAuthorisationResponse.getPaymentType();
        SpiPayment payment = this.mapToSpiPayment(pisConsentAuthorisationResponse.getPayments(), paymentType);
        AspspConsentData aspspConsentData = this.pisConsentDataService.getAspspConsentData(request.getPaymentId());
        SpiPsuData psuData = this.xs2aToSpiPsuDataMapper.mapToSpiPsuData(request.getPsuData());
        SpiResponse authPsuResponse = this.paymentCancellationSpi.authorisePsu(psuData, request.getPassword(), (Object)payment, aspspConsentData);
        aspspConsentData = authPsuResponse.getAspspConsentData();
        this.pisConsentDataService.updateAspspConsentData(aspspConsentData);
        if (authPsuResponse.hasError()) {
            return new Xs2aUpdatePisConsentPsuDataResponse(this.spiErrorMapper.mapToErrorHolder(authPsuResponse));
        }
        SpiResponse availableScaMethodsResponse = this.paymentCancellationSpi.requestAvailableScaMethods(psuData, (Object)payment, aspspConsentData);
        this.pisConsentDataService.updateAspspConsentData(availableScaMethodsResponse.getAspspConsentData());
        if (availableScaMethodsResponse.hasError()) {
            return new Xs2aUpdatePisConsentPsuDataResponse(this.spiErrorMapper.mapToErrorHolder(availableScaMethodsResponse));
        }
        List spiScaMethods = (List)availableScaMethodsResponse.getPayload();
        if (CollectionUtils.isEmpty((Collection)spiScaMethods)) {
            SpiResponse executePaymentResponse = this.paymentCancellationSpi.cancelPaymentWithoutSca(psuData, payment, availableScaMethodsResponse.getAspspConsentData());
            this.pisConsentDataService.updateAspspConsentData(executePaymentResponse.getAspspConsentData());
            if (executePaymentResponse.hasError()) {
                return new Xs2aUpdatePisConsentPsuDataResponse(this.spiErrorMapper.mapToErrorHolder(executePaymentResponse));
            }
            this.pisConsentService.updateConsentStatusById(request.getPaymentId(), ConsentStatus.REVOKED_BY_PSU);
            Xs2aUpdatePisConsentPsuDataResponse response = new Xs2aUpdatePisConsentPsuDataResponse(ScaStatus.FINALISED);
            response.setPsuId(psuData.getPsuId());
            return response;
        }
        if (this.isSingleScaMethod(spiScaMethods)) {
            SpiAuthenticationObject chosenMethod = (SpiAuthenticationObject)spiScaMethods.get(0);
            SpiResponse authCodeResponse = this.paymentCancellationSpi.requestAuthorisationCode(psuData, chosenMethod.getAuthenticationMethodId(), (Object)payment, aspspConsentData);
            this.pisConsentDataService.updateAspspConsentData(authCodeResponse.getAspspConsentData());
            if (authCodeResponse.hasError()) {
                return new Xs2aUpdatePisConsentPsuDataResponse(this.spiErrorMapper.mapToErrorHolder(authCodeResponse));
            }
            ChallengeData challengeData = this.mapToChallengeData((SpiAuthorizationCodeResult)authCodeResponse.getPayload());
            Xs2aUpdatePisConsentPsuDataResponse response = new Xs2aUpdatePisConsentPsuDataResponse(ScaStatus.SCAMETHODSELECTED);
            response.setPsuId(psuData.getPsuId());
            response.setChosenScaMethod(this.spiToXs2aAuthenticationObjectMapper.mapToXs2aAuthenticationObject(chosenMethod));
            response.setChallengeData(challengeData);
            return response;
        }
        if (this.isMultipleScaMethods(spiScaMethods)) {
            Xs2aUpdatePisConsentPsuDataResponse response = new Xs2aUpdatePisConsentPsuDataResponse(ScaStatus.PSUAUTHENTICATED);
            response.setPsuId(psuData.getPsuId());
            response.setAvailableScaMethods(this.spiToXs2aAuthenticationObjectMapper.mapToXs2aListAuthenticationObject(spiScaMethods));
            return response;
        }
        return new Xs2aUpdatePisConsentPsuDataResponse(ScaStatus.FAILED);
    }

    private ChallengeData mapToChallengeData(SpiAuthorizationCodeResult authorizationCodeResult) {
        if (authorizationCodeResult != null && !authorizationCodeResult.isEmpty()) {
            return authorizationCodeResult.getChallengeData();
        }
        return null;
    }

    private boolean isSingleScaMethod(List<SpiAuthenticationObject> spiScaMethods) {
        return spiScaMethods.size() == 1;
    }

    private boolean isMultipleScaMethods(List<SpiAuthenticationObject> spiScaMethods) {
        return spiScaMethods.size() > 1;
    }
}

