/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.authorization.pis;

import de.adorsys.psd2.consent.api.CmsAuthorisationType;
import de.adorsys.psd2.consent.api.pis.authorisation.CreatePisConsentAuthorisationResponse;
import de.adorsys.psd2.consent.api.pis.authorisation.GetPisConsentAuthorisationResponse;
import de.adorsys.psd2.consent.api.pis.authorisation.UpdatePisConsentPsuDataRequest;
import de.adorsys.psd2.consent.api.service.PisConsentService;
import de.adorsys.psd2.xs2a.config.factory.PisScaStageAuthorisationFactory;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.domain.consent.pis.Xs2aUpdatePisConsentPsuDataRequest;
import de.adorsys.psd2.xs2a.domain.consent.pis.Xs2aUpdatePisConsentPsuDataResponse;
import de.adorsys.psd2.xs2a.service.authorization.pis.stage.PisScaStage;
import de.adorsys.psd2.xs2a.service.mapper.consent.Xs2aPisConsentMapper;
import java.beans.ConstructorProperties;
import org.springframework.stereotype.Service;

@Service
public class PisAuthorisationService {
    private final PisConsentService pisConsentService;
    private final PisScaStageAuthorisationFactory pisScaStageAuthorisationFactory;
    private final Xs2aPisConsentMapper pisConsentMapper;

    public CreatePisConsentAuthorisationResponse createPisConsentAuthorisation(String paymentId, PsuIdData psuData) {
        return this.pisConsentService.createAuthorization(paymentId, CmsAuthorisationType.CREATED, psuData).orElse(null);
    }

    public Xs2aUpdatePisConsentPsuDataResponse updatePisConsentAuthorisation(Xs2aUpdatePisConsentPsuDataRequest request) {
        GetPisConsentAuthorisationResponse response = this.pisConsentService.getPisConsentAuthorisationById(request.getAuthorizationId()).orElse(null);
        PisScaStage service = (PisScaStage)this.pisScaStageAuthorisationFactory.getService("PIS_" + response.getScaStatus().name());
        Xs2aUpdatePisConsentPsuDataResponse stageResponse = (Xs2aUpdatePisConsentPsuDataResponse)service.apply(request, response);
        if (!stageResponse.hasError()) {
            this.doUpdatePisConsentAuthorisation(this.pisConsentMapper.mapToCmsUpdateConsentPsuDataReq(request, stageResponse));
        }
        return stageResponse;
    }

    public Xs2aUpdatePisConsentPsuDataResponse updatePisConsentCancellationAuthorisation(Xs2aUpdatePisConsentPsuDataRequest request) {
        GetPisConsentAuthorisationResponse response = this.pisConsentService.getPisConsentCancellationAuthorisationById(request.getAuthorizationId()).orElse(null);
        PisScaStage service = (PisScaStage)this.pisScaStageAuthorisationFactory.getService("PIS_CANC_" + response.getScaStatus().name());
        Xs2aUpdatePisConsentPsuDataResponse stageResponse = (Xs2aUpdatePisConsentPsuDataResponse)service.apply(request, response);
        if (!stageResponse.hasError()) {
            this.doUpdatePisConsentCancellationAuthorisation(this.pisConsentMapper.mapToCmsUpdateConsentPsuDataReq(request, stageResponse));
        }
        return stageResponse;
    }

    public void doUpdatePisConsentAuthorisation(UpdatePisConsentPsuDataRequest request) {
        this.pisConsentService.updateConsentAuthorisation(request.getAuthorizationId(), request);
    }

    public void doUpdatePisConsentCancellationAuthorisation(UpdatePisConsentPsuDataRequest request) {
        this.pisConsentService.updateConsentCancellationAuthorisation(request.getAuthorizationId(), request);
    }

    public CreatePisConsentAuthorisationResponse createPisConsentAuthorisationCancellation(String paymentId, PsuIdData psuData) {
        return this.pisConsentService.createAuthorizationCancellation(paymentId, CmsAuthorisationType.CANCELLED, psuData).orElse(null);
    }

    public String getCancellationAuthorisationSubResources(String paymentId) {
        return this.pisConsentService.getAuthorisationByPaymentId(paymentId, CmsAuthorisationType.CANCELLED).orElse(null);
    }

    @ConstructorProperties(value={"pisConsentService", "pisScaStageAuthorisationFactory", "pisConsentMapper"})
    public PisAuthorisationService(PisConsentService pisConsentService, PisScaStageAuthorisationFactory pisScaStageAuthorisationFactory, Xs2aPisConsentMapper pisConsentMapper) {
        this.pisConsentService = pisConsentService;
        this.pisScaStageAuthorisationFactory = pisScaStageAuthorisationFactory;
        this.pisConsentMapper = pisConsentMapper;
    }
}

