/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.authorization.pis;

import de.adorsys.psd2.xs2a.core.profile.PaymentType;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aCreatePisConsentCancellationAuthorisationResponse;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aPaymentCancellationAuthorisationSubResource;
import de.adorsys.psd2.xs2a.domain.consent.Xsa2CreatePisConsentAuthorisationResponse;
import de.adorsys.psd2.xs2a.domain.consent.pis.Xs2aUpdatePisConsentPsuDataRequest;
import de.adorsys.psd2.xs2a.domain.consent.pis.Xs2aUpdatePisConsentPsuDataResponse;
import de.adorsys.psd2.xs2a.service.authorization.pis.PisAuthorisationService;
import de.adorsys.psd2.xs2a.service.authorization.pis.PisScaAuthorisationService;
import de.adorsys.psd2.xs2a.service.mapper.consent.Xs2aPisConsentMapper;
import java.beans.ConstructorProperties;
import java.util.Optional;

public class EmbeddedPisScaAuthorisationService
implements PisScaAuthorisationService {
    private final PisAuthorisationService authorisationService;
    private final Xs2aPisConsentMapper pisConsentMapper;

    @Override
    public Optional<Xsa2CreatePisConsentAuthorisationResponse> createConsentAuthorisation(String paymentId, PaymentType paymentType, PsuIdData psuData) {
        return this.pisConsentMapper.mapToXsa2CreatePisConsentAuthorizationResponse(this.authorisationService.createPisConsentAuthorisation(paymentId, psuData), paymentType);
    }

    @Override
    public Xs2aUpdatePisConsentPsuDataResponse updateConsentPsuData(Xs2aUpdatePisConsentPsuDataRequest request) {
        return this.authorisationService.updatePisConsentAuthorisation(request);
    }

    @Override
    public Optional<Xs2aCreatePisConsentCancellationAuthorisationResponse> createConsentCancellationAuthorisation(String paymentId, PaymentType paymentType, PsuIdData psuData) {
        return this.pisConsentMapper.mapToXs2aCreatePisConsentCancellationAuthorisationResponse(this.authorisationService.createPisConsentAuthorisationCancellation(paymentId, psuData), paymentType);
    }

    @Override
    public Optional<Xs2aPaymentCancellationAuthorisationSubResource> getCancellationAuthorisationSubResources(String paymentId) {
        return this.pisConsentMapper.mapToXs2aPaymentCancellationAuthorisationSubResource(this.authorisationService.getCancellationAuthorisationSubResources(paymentId));
    }

    @Override
    public Xs2aUpdatePisConsentPsuDataResponse updateConsentCancellationPsuData(Xs2aUpdatePisConsentPsuDataRequest request) {
        return this.authorisationService.updatePisConsentCancellationAuthorisation(request);
    }

    @ConstructorProperties(value={"authorisationService", "pisConsentMapper"})
    public EmbeddedPisScaAuthorisationService(PisAuthorisationService authorisationService, Xs2aPisConsentMapper pisConsentMapper) {
        this.authorisationService = authorisationService;
        this.pisConsentMapper = pisConsentMapper;
    }
}

