/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.authorization.ais.stage;

import de.adorsys.psd2.xs2a.core.consent.ConsentStatus;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import de.adorsys.psd2.xs2a.domain.consent.AccountConsent;
import de.adorsys.psd2.xs2a.domain.consent.ConsentAuthorizationResponseLinkType;
import de.adorsys.psd2.xs2a.domain.consent.UpdateConsentPsuDataReq;
import de.adorsys.psd2.xs2a.domain.consent.UpdateConsentPsuDataResponse;
import de.adorsys.psd2.xs2a.service.authorization.ais.stage.AisScaStage;
import de.adorsys.psd2.xs2a.service.consent.AisConsentDataService;
import de.adorsys.psd2.xs2a.service.consent.Xs2aAisConsentService;
import de.adorsys.psd2.xs2a.service.mapper.consent.Xs2aAisConsentMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiResponseStatusToXs2aMessageErrorCodeMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aAuthenticationObjectMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.Xs2aToSpiPsuDataMapper;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import de.adorsys.psd2.xs2a.spi.service.AisConsentSpi;
import org.springframework.stereotype.Service;

@Service(value="AIS_SCAMETHODSELECTED")
public class AisScaAuthenticatedStage
extends AisScaStage<UpdateConsentPsuDataReq, UpdateConsentPsuDataResponse> {
    public AisScaAuthenticatedStage(Xs2aAisConsentService aisConsentService, AisConsentDataService aisConsentDataService, AisConsentSpi aisConsentSpi, Xs2aAisConsentMapper aisConsentMapper, SpiResponseStatusToXs2aMessageErrorCodeMapper messageErrorCodeMapper, Xs2aToSpiPsuDataMapper psuDataMapper, SpiToXs2aAuthenticationObjectMapper spiToXs2aAuthenticationObjectMapper) {
        super(aisConsentService, aisConsentDataService, aisConsentSpi, aisConsentMapper, messageErrorCodeMapper, psuDataMapper, spiToXs2aAuthenticationObjectMapper);
    }

    @Override
    public UpdateConsentPsuDataResponse apply(UpdateConsentPsuDataReq request) {
        AccountConsent accountConsent = this.aisConsentService.getAccountConsentById(request.getConsentId());
        PsuIdData psuData = request.getPsuData();
        SpiResponse spiResponse = this.aisConsentSpi.verifyScaAuthorisation(this.psuDataMapper.mapToSpiPsuData(psuData), this.aisConsentMapper.mapToSpiScaConfirmation(request), this.aisConsentMapper.mapToSpiAccountConsent(accountConsent), this.aisConsentDataService.getAspspConsentDataByConsentId(request.getConsentId()));
        this.aisConsentDataService.updateAspspConsentData(spiResponse.getAspspConsentData());
        if (spiResponse.hasError()) {
            return this.createFailedResponse(this.messageErrorCodeMapper.mapToMessageErrorCode(spiResponse.getResponseStatus()), spiResponse.getMessages());
        }
        this.aisConsentService.updateConsentStatus(request.getConsentId(), ConsentStatus.VALID);
        UpdateConsentPsuDataResponse response = new UpdateConsentPsuDataResponse();
        response.setScaAuthenticationData(request.getScaAuthenticationData());
        response.setScaStatus(ScaStatus.FINALISED);
        response.setResponseLinkType(ConsentAuthorizationResponseLinkType.START_AUTHORISATION_WITH_AUTHENTICATION_METHOD_SELECTION);
        return response;
    }
}

