/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.authorization.ais;

import de.adorsys.psd2.xs2a.config.factory.AisScaStageAuthorisationFactory;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import de.adorsys.psd2.xs2a.domain.consent.AccountConsentAuthorization;
import de.adorsys.psd2.xs2a.domain.consent.ConsentAuthorizationResponseLinkType;
import de.adorsys.psd2.xs2a.domain.consent.CreateConsentAuthorizationResponse;
import de.adorsys.psd2.xs2a.domain.consent.UpdateConsentPsuDataReq;
import de.adorsys.psd2.xs2a.domain.consent.UpdateConsentPsuDataResponse;
import de.adorsys.psd2.xs2a.service.authorization.ais.AisAuthorizationService;
import de.adorsys.psd2.xs2a.service.authorization.ais.stage.AisScaStage;
import de.adorsys.psd2.xs2a.service.consent.Xs2aAisConsentService;
import de.adorsys.psd2.xs2a.service.mapper.consent.Xs2aAisConsentMapper;
import java.beans.ConstructorProperties;
import java.util.Optional;
import org.springframework.stereotype.Service;

@Service
public class EmbeddedAisAuthorizationService
implements AisAuthorizationService {
    private final Xs2aAisConsentService aisConsentService;
    private final Xs2aAisConsentMapper aisConsentMapper;
    private final AisScaStageAuthorisationFactory scaStageAuthorisationFactory;

    @Override
    public Optional<CreateConsentAuthorizationResponse> createConsentAuthorization(PsuIdData psuData, String consentId) {
        return this.aisConsentService.createAisConsentAuthorization(consentId, ScaStatus.valueOf((String)ScaStatus.STARTED.name()), psuData).map(authId -> {
            CreateConsentAuthorizationResponse resp = new CreateConsentAuthorizationResponse();
            resp.setConsentId(consentId);
            resp.setAuthorizationId((String)authId);
            resp.setScaStatus(ScaStatus.STARTED);
            resp.setResponseLinkType(ConsentAuthorizationResponseLinkType.START_AUTHORISATION_WITH_PSU_AUTHENTICATION);
            return resp;
        });
    }

    @Override
    public AccountConsentAuthorization getAccountConsentAuthorizationById(String authorizationId, String consentId) {
        return this.aisConsentService.getAccountConsentAuthorizationById(authorizationId, consentId);
    }

    @Override
    public UpdateConsentPsuDataResponse updateConsentPsuData(UpdateConsentPsuDataReq request, AccountConsentAuthorization consentAuthorization) {
        AisScaStage service = (AisScaStage)this.scaStageAuthorisationFactory.getService("AIS_" + consentAuthorization.getScaStatus().name());
        UpdateConsentPsuDataResponse response = (UpdateConsentPsuDataResponse)service.apply(request);
        if (!response.hasError()) {
            this.aisConsentService.updateConsentAuthorization(this.aisConsentMapper.mapToSpiUpdateConsentPsuDataReq(response, request));
        }
        return response;
    }

    @ConstructorProperties(value={"aisConsentService", "aisConsentMapper", "scaStageAuthorisationFactory"})
    public EmbeddedAisAuthorizationService(Xs2aAisConsentService aisConsentService, Xs2aAisConsentMapper aisConsentMapper, AisScaStageAuthorisationFactory scaStageAuthorisationFactory) {
        this.aisConsentService = aisConsentService;
        this.aisConsentMapper = aisConsentMapper;
        this.scaStageAuthorisationFactory = scaStageAuthorisationFactory;
    }
}

