/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service;

import de.adorsys.psd2.consent.api.pis.PisPayment;
import de.adorsys.psd2.consent.api.pis.proto.PisConsentResponse;
import de.adorsys.psd2.xs2a.config.factory.ReadPaymentFactory;
import de.adorsys.psd2.xs2a.core.consent.AspspConsentData;
import de.adorsys.psd2.xs2a.core.event.EventType;
import de.adorsys.psd2.xs2a.core.pis.TransactionStatus;
import de.adorsys.psd2.xs2a.core.profile.PaymentProduct;
import de.adorsys.psd2.xs2a.core.profile.PaymentType;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.tpp.TppInfo;
import de.adorsys.psd2.xs2a.domain.ErrorHolder;
import de.adorsys.psd2.xs2a.domain.MessageErrorCode;
import de.adorsys.psd2.xs2a.domain.ResponseObject;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aPisConsent;
import de.adorsys.psd2.xs2a.domain.pis.BulkPayment;
import de.adorsys.psd2.xs2a.domain.pis.CancelPaymentResponse;
import de.adorsys.psd2.xs2a.domain.pis.PaymentInformationResponse;
import de.adorsys.psd2.xs2a.domain.pis.PaymentInitiationParameters;
import de.adorsys.psd2.xs2a.domain.pis.PeriodicPayment;
import de.adorsys.psd2.xs2a.domain.pis.SinglePayment;
import de.adorsys.psd2.xs2a.exception.MessageError;
import de.adorsys.psd2.xs2a.service.TppService;
import de.adorsys.psd2.xs2a.service.consent.PisConsentDataService;
import de.adorsys.psd2.xs2a.service.consent.PisPsuDataService;
import de.adorsys.psd2.xs2a.service.consent.Xs2aPisConsentService;
import de.adorsys.psd2.xs2a.service.event.Xs2aEventService;
import de.adorsys.psd2.xs2a.service.mapper.consent.Xs2aPisConsentMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiErrorMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aTransactionalStatusMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.Xs2aToSpiPsuDataMapper;
import de.adorsys.psd2.xs2a.service.payment.CancelPaymentService;
import de.adorsys.psd2.xs2a.service.payment.CreateBulkPaymentService;
import de.adorsys.psd2.xs2a.service.payment.CreatePeriodicPaymentService;
import de.adorsys.psd2.xs2a.service.payment.CreateSinglePaymentService;
import de.adorsys.psd2.xs2a.service.payment.ReadPaymentService;
import de.adorsys.psd2.xs2a.service.profile.AspspProfileServiceWrapper;
import de.adorsys.psd2.xs2a.spi.domain.common.SpiTransactionStatus;
import de.adorsys.psd2.xs2a.spi.domain.payment.SpiBulkPayment;
import de.adorsys.psd2.xs2a.spi.domain.payment.SpiPeriodicPayment;
import de.adorsys.psd2.xs2a.spi.domain.payment.SpiSinglePayment;
import de.adorsys.psd2.xs2a.spi.domain.psu.SpiPsuData;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import de.adorsys.psd2.xs2a.spi.service.BulkPaymentSpi;
import de.adorsys.psd2.xs2a.spi.service.PeriodicPaymentSpi;
import de.adorsys.psd2.xs2a.spi.service.SinglePaymentSpi;
import de.adorsys.psd2.xs2a.spi.service.SpiPayment;
import java.beans.ConstructorProperties;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PaymentService {
    private static final Logger log = LoggerFactory.getLogger(PaymentService.class);
    private final ReadPaymentFactory readPaymentFactory;
    private final Xs2aPisConsentService pisConsentService;
    private final PisConsentDataService pisConsentDataService;
    private final PisPsuDataService pisPsuDataService;
    private final TppService tppService;
    private final CreateSinglePaymentService createSinglePaymentService;
    private final CreatePeriodicPaymentService createPeriodicPaymentService;
    private final CreateBulkPaymentService createBulkPaymentService;
    private final Xs2aPisConsentMapper xs2aPisConsentMapper;
    private final Xs2aToSpiPsuDataMapper psuDataMapper;
    private final SinglePaymentSpi singlePaymentSpi;
    private final PeriodicPaymentSpi periodicPaymentSpi;
    private final BulkPaymentSpi bulkPaymentSpi;
    private final SpiToXs2aTransactionalStatusMapper spiToXs2aTransactionalStatus;
    private final AspspProfileServiceWrapper profileService;
    private final CancelPaymentService cancelPaymentService;
    private final SpiErrorMapper spiErrorMapper;
    private final Xs2aEventService xs2aEventService;

    public ResponseObject createPayment(Object payment, PaymentInitiationParameters paymentInitiationParameters) {
        this.xs2aEventService.recordTppRequest(EventType.PAYMENT_INITIATION_REQUEST_RECEIVED, payment);
        TppInfo tppInfo = this.tppService.getTppInfo();
        tppInfo.setRedirectUri(paymentInitiationParameters.getTppRedirectUri());
        tppInfo.setNokRedirectUri(paymentInitiationParameters.getTppNokRedirectUri());
        Xs2aPisConsent pisConsent = this.xs2aPisConsentMapper.mapToXs2aPisConsent(this.pisConsentService.createPisConsent(paymentInitiationParameters, tppInfo), paymentInitiationParameters.getPsuData());
        if (StringUtils.isBlank((CharSequence)pisConsent.getConsentId())) {
            return ResponseObject.builder().fail(new MessageError(MessageErrorCode.CONSENT_UNKNOWN_400)).build();
        }
        if (paymentInitiationParameters.getPaymentType() == PaymentType.SINGLE) {
            return this.createSinglePaymentService.createPayment((SinglePayment)payment, paymentInitiationParameters, tppInfo, pisConsent);
        }
        if (paymentInitiationParameters.getPaymentType() == PaymentType.PERIODIC) {
            return this.createPeriodicPaymentService.createPayment((PeriodicPayment)payment, paymentInitiationParameters, tppInfo, pisConsent);
        }
        return this.createBulkPaymentService.createPayment((BulkPayment)payment, paymentInitiationParameters, tppInfo, pisConsent);
    }

    public ResponseObject getPaymentById(PaymentType paymentType, String paymentId) {
        this.xs2aEventService.recordPisTppRequest(paymentId, EventType.GET_PAYMENT_REQUEST_RECEIVED);
        AspspConsentData aspspConsentData = this.pisConsentDataService.getAspspConsentData(paymentId);
        PisPayment payment = this.pisConsentService.getPisConsentById(aspspConsentData.getConsentId()).map(PisConsentResponse::getPayments).map(payments -> (PisPayment)payments.get(0)).orElse(null);
        if (payment == null) {
            return ResponseObject.builder().fail(new MessageError(MessageErrorCode.FORMAT_ERROR, "Payment not found")).build();
        }
        PsuIdData psuData = this.pisPsuDataService.getPsuDataByPaymentId(paymentId);
        ReadPaymentService readPaymentService = (ReadPaymentService)this.readPaymentFactory.getService(paymentType.getValue());
        PaymentInformationResponse response = (PaymentInformationResponse)readPaymentService.getPayment(payment, PaymentProduct.SEPA, psuData, aspspConsentData);
        if (response.hasError()) {
            return ResponseObject.builder().fail(new MessageError(response.getErrorHolder().getErrorCode(), response.getErrorHolder().getMessage())).build();
        }
        return ResponseObject.builder().body(response.getPayment()).build();
    }

    public ResponseObject<TransactionStatus> getPaymentStatusById(PaymentType paymentType, String paymentId) {
        SpiResponse spiResponse;
        SpiSinglePayment payment;
        this.xs2aEventService.recordPisTppRequest(paymentId, EventType.GET_TRANSACTION_STATUS_REQUEST_RECEIVED);
        AspspConsentData aspspConsentData = this.pisConsentDataService.getAspspConsentData(paymentId);
        PsuIdData psuData = this.pisPsuDataService.getPsuDataByPaymentId(paymentId);
        String internalPaymentId = this.pisConsentDataService.getInternalPaymentIdByEncryptedString(paymentId);
        SpiPsuData spiPsuData = this.psuDataMapper.mapToSpiPsuData(psuData);
        if (paymentType == PaymentType.SINGLE) {
            payment = new SpiSinglePayment(null);
            payment.setPaymentId(internalPaymentId);
            spiResponse = this.singlePaymentSpi.getPaymentStatusById(spiPsuData, payment, aspspConsentData);
        } else if (paymentType == PaymentType.PERIODIC) {
            payment = new SpiPeriodicPayment(null);
            payment.setPaymentId(internalPaymentId);
            spiResponse = this.periodicPaymentSpi.getPaymentStatusById(spiPsuData, (SpiPeriodicPayment)payment, aspspConsentData);
        } else {
            payment = new SpiBulkPayment();
            payment.setPaymentId(internalPaymentId);
            spiResponse = this.bulkPaymentSpi.getPaymentStatusById(spiPsuData, (SpiBulkPayment)payment, aspspConsentData);
        }
        this.pisConsentDataService.updateAspspConsentData(spiResponse.getAspspConsentData());
        if (spiResponse.hasError()) {
            ErrorHolder errorHolder = this.spiErrorMapper.mapToErrorHolder(spiResponse);
            return ResponseObject.builder().fail(new MessageError(errorHolder.getErrorCode(), errorHolder.getMessage())).build();
        }
        TransactionStatus transactionStatus = this.spiToXs2aTransactionalStatus.mapToTransactionStatus((SpiTransactionStatus)spiResponse.getPayload());
        return Optional.ofNullable(transactionStatus).map(tr -> ResponseObject.builder().body((TransactionStatus)tr).build()).orElseGet(ResponseObject.builder().fail(new MessageError(MessageErrorCode.RESOURCE_UNKNOWN_403))::build);
    }

    public ResponseObject<CancelPaymentResponse> cancelPayment(PaymentType paymentType, String paymentId) {
        SpiBulkPayment payment;
        this.xs2aEventService.recordPisTppRequest(paymentId, EventType.PAYMENT_CANCELLATION_REQUEST_RECEIVED);
        String internalPaymentId = this.pisConsentDataService.getInternalPaymentIdByEncryptedString(paymentId);
        switch (paymentType) {
            case SINGLE: {
                SpiSinglePayment singlePayment = new SpiSinglePayment(null);
                singlePayment.setPaymentId(internalPaymentId);
                payment = singlePayment;
                break;
            }
            case PERIODIC: {
                SpiPeriodicPayment periodicPayment = new SpiPeriodicPayment(null);
                periodicPayment.setPaymentId(internalPaymentId);
                payment = periodicPayment;
                break;
            }
            case BULK: {
                SpiBulkPayment bulkPayment = new SpiBulkPayment();
                bulkPayment.setPaymentId(internalPaymentId);
                payment = bulkPayment;
                break;
            }
            default: {
                log.error("Unknown payment type: {}", (Object)paymentType);
                return ResponseObject.builder().fail(new MessageError(MessageErrorCode.FORMAT_ERROR)).build();
            }
        }
        AspspConsentData consentData = this.pisConsentDataService.getAspspConsentData(paymentId);
        PsuIdData psuData = this.pisPsuDataService.getPsuDataByPaymentId(paymentId);
        SpiPsuData spiPsuData = this.psuDataMapper.mapToSpiPsuData(psuData);
        if (this.profileService.isPaymentCancellationAuthorizationMandated()) {
            return this.cancelPaymentService.initiatePaymentCancellation(spiPsuData, (SpiPayment)payment, consentData);
        }
        ResponseObject<CancelPaymentResponse> cancellationResponse = this.cancelPaymentService.cancelPaymentWithoutAuthorisation(spiPsuData, (SpiPayment)payment, consentData);
        this.pisConsentService.revokeConsentById(paymentId);
        return cancellationResponse;
    }

    @ConstructorProperties(value={"readPaymentFactory", "pisConsentService", "pisConsentDataService", "pisPsuDataService", "tppService", "createSinglePaymentService", "createPeriodicPaymentService", "createBulkPaymentService", "xs2aPisConsentMapper", "psuDataMapper", "singlePaymentSpi", "periodicPaymentSpi", "bulkPaymentSpi", "spiToXs2aTransactionalStatus", "profileService", "cancelPaymentService", "spiErrorMapper", "xs2aEventService"})
    public PaymentService(ReadPaymentFactory readPaymentFactory, Xs2aPisConsentService pisConsentService, PisConsentDataService pisConsentDataService, PisPsuDataService pisPsuDataService, TppService tppService, CreateSinglePaymentService createSinglePaymentService, CreatePeriodicPaymentService createPeriodicPaymentService, CreateBulkPaymentService createBulkPaymentService, Xs2aPisConsentMapper xs2aPisConsentMapper, Xs2aToSpiPsuDataMapper psuDataMapper, SinglePaymentSpi singlePaymentSpi, PeriodicPaymentSpi periodicPaymentSpi, BulkPaymentSpi bulkPaymentSpi, SpiToXs2aTransactionalStatusMapper spiToXs2aTransactionalStatus, AspspProfileServiceWrapper profileService, CancelPaymentService cancelPaymentService, SpiErrorMapper spiErrorMapper, Xs2aEventService xs2aEventService) {
        this.readPaymentFactory = readPaymentFactory;
        this.pisConsentService = pisConsentService;
        this.pisConsentDataService = pisConsentDataService;
        this.pisPsuDataService = pisPsuDataService;
        this.tppService = tppService;
        this.createSinglePaymentService = createSinglePaymentService;
        this.createPeriodicPaymentService = createPeriodicPaymentService;
        this.createBulkPaymentService = createBulkPaymentService;
        this.xs2aPisConsentMapper = xs2aPisConsentMapper;
        this.psuDataMapper = psuDataMapper;
        this.singlePaymentSpi = singlePaymentSpi;
        this.periodicPaymentSpi = periodicPaymentSpi;
        this.bulkPaymentSpi = bulkPaymentSpi;
        this.spiToXs2aTransactionalStatus = spiToXs2aTransactionalStatus;
        this.profileService = profileService;
        this.cancelPaymentService = cancelPaymentService;
        this.spiErrorMapper = spiErrorMapper;
        this.xs2aEventService = xs2aEventService;
    }
}

