/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service;

import de.adorsys.psd2.consent.api.service.PiisConsentService;
import de.adorsys.psd2.xs2a.core.consent.AspspConsentData;
import de.adorsys.psd2.xs2a.core.event.EventType;
import de.adorsys.psd2.xs2a.core.profile.AccountReferenceSelector;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.domain.MessageErrorCode;
import de.adorsys.psd2.xs2a.domain.ResponseObject;
import de.adorsys.psd2.xs2a.domain.fund.FundsConfirmationRequest;
import de.adorsys.psd2.xs2a.domain.fund.FundsConfirmationResponse;
import de.adorsys.psd2.xs2a.exception.MessageError;
import de.adorsys.psd2.xs2a.service.FundsConfirmationConsentDataService;
import de.adorsys.psd2.xs2a.service.FundsConfirmationPsuDataService;
import de.adorsys.psd2.xs2a.service.event.Xs2aEventService;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.Xs2aToSpiFundsConfirmationRequestMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.Xs2aToSpiPsuDataMapper;
import de.adorsys.psd2.xs2a.service.profile.AspspProfileServiceWrapper;
import de.adorsys.psd2.xs2a.service.validator.PiisConsentValidationService;
import de.adorsys.psd2.xs2a.spi.domain.fund.SpiFundsConfirmationRequest;
import de.adorsys.psd2.xs2a.spi.domain.psu.SpiPsuData;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import de.adorsys.psd2.xs2a.spi.service.FundsConfirmationSpi;
import java.beans.ConstructorProperties;
import java.util.List;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class FundsConfirmationService {
    private static final Logger log = LoggerFactory.getLogger(FundsConfirmationService.class);
    private final AspspProfileServiceWrapper profileService;
    private final FundsConfirmationSpi fundsConfirmationSpi;
    private final FundsConfirmationConsentDataService fundsConfirmationConsentDataService;
    private final FundsConfirmationPsuDataService fundsConfirmationPsuDataService;
    private final Xs2aToSpiPsuDataMapper psuDataMapper;
    private final Xs2aToSpiFundsConfirmationRequestMapper xs2aToSpiFundsConfirmationRequestMapper;
    private final PiisConsentValidationService piisConsentValidationService;
    private final PiisConsentService piisConsentService;
    private final Xs2aEventService xs2aEventService;

    public ResponseObject<FundsConfirmationResponse> fundsConfirmation(FundsConfirmationRequest request) {
        this.xs2aEventService.recordTppRequest(EventType.FUNDS_CONFIRMATION_REQUEST_RECEIVED, request);
        String consentId = null;
        if (this.profileService.isPiisConsentSupported()) {
            AccountReferenceSelector selector = request.getPsuAccount().getUsedAccountReferenceSelector();
            if (selector == null) {
                log.warn("No account identifier in the request {}", (Object)request.getPsuAccount());
                return ResponseObject.builder().fail(new MessageError(MessageErrorCode.FORMAT_ERROR)).build();
            }
            List response = this.piisConsentService.getPiisConsentListByAccountIdentifier(request.getPsuAccount().getCurrency(), selector, selector.getAccountReferenceValue(request.getPsuAccount()));
            ResponseObject<String> validationResult = this.piisConsentValidationService.validatePiisConsentData(response);
            if (validationResult.hasError()) {
                return ResponseObject.builder().fail(validationResult.getError()).build();
            }
            consentId = validationResult.getBody();
        }
        SpiFundsConfirmationRequest spiRequest = this.xs2aToSpiFundsConfirmationRequestMapper.mapToSpiFundsConfirmationRequest(request);
        AspspConsentData aspspConsentData = this.fundsConfirmationConsentDataService.getAspspConsentDataByConsentId(consentId);
        PsuIdData psuData = this.fundsConfirmationPsuDataService.getPsuDataByConsentId(consentId);
        SpiPsuData spiPsuData = this.psuDataMapper.mapToSpiPsuData(psuData);
        SpiResponse fundsSufficientCheck = this.fundsConfirmationSpi.performFundsSufficientCheck(spiPsuData, consentId, spiRequest, aspspConsentData);
        aspspConsentData = fundsSufficientCheck.getAspspConsentData();
        this.fundsConfirmationConsentDataService.updateAspspConsentData(aspspConsentData);
        if (fundsSufficientCheck.hasError()) {
            return ResponseObject.builder().fail(new MessageError(MessageErrorCode.RESOURCE_UNKNOWN_404)).build();
        }
        FundsConfirmationResponse fundsConfirmationResponse = new FundsConfirmationResponse(BooleanUtils.isTrue((Boolean)((Boolean)fundsSufficientCheck.getPayload())));
        return ResponseObject.builder().body(fundsConfirmationResponse).build();
    }

    @ConstructorProperties(value={"profileService", "fundsConfirmationSpi", "fundsConfirmationConsentDataService", "fundsConfirmationPsuDataService", "psuDataMapper", "xs2aToSpiFundsConfirmationRequestMapper", "piisConsentValidationService", "piisConsentService", "xs2aEventService"})
    public FundsConfirmationService(AspspProfileServiceWrapper profileService, FundsConfirmationSpi fundsConfirmationSpi, FundsConfirmationConsentDataService fundsConfirmationConsentDataService, FundsConfirmationPsuDataService fundsConfirmationPsuDataService, Xs2aToSpiPsuDataMapper psuDataMapper, Xs2aToSpiFundsConfirmationRequestMapper xs2aToSpiFundsConfirmationRequestMapper, PiisConsentValidationService piisConsentValidationService, PiisConsentService piisConsentService, Xs2aEventService xs2aEventService) {
        this.profileService = profileService;
        this.fundsConfirmationSpi = fundsConfirmationSpi;
        this.fundsConfirmationConsentDataService = fundsConfirmationConsentDataService;
        this.fundsConfirmationPsuDataService = fundsConfirmationPsuDataService;
        this.psuDataMapper = psuDataMapper;
        this.xs2aToSpiFundsConfirmationRequestMapper = xs2aToSpiFundsConfirmationRequestMapper;
        this.piisConsentValidationService = piisConsentValidationService;
        this.piisConsentService = piisConsentService;
        this.xs2aEventService = xs2aEventService;
    }
}

