/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service;

import de.adorsys.psd2.xs2a.core.consent.ConsentStatus;
import de.adorsys.psd2.xs2a.core.event.EventType;
import de.adorsys.psd2.xs2a.core.profile.PaymentType;
import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.domain.MessageErrorCode;
import de.adorsys.psd2.xs2a.domain.ResponseObject;
import de.adorsys.psd2.xs2a.domain.TppMessageInformation;
import de.adorsys.psd2.xs2a.domain.account.Xs2aAccountReference;
import de.adorsys.psd2.xs2a.domain.consent.AccountConsent;
import de.adorsys.psd2.xs2a.domain.consent.AccountConsentAuthorization;
import de.adorsys.psd2.xs2a.domain.consent.ConsentStatusResponse;
import de.adorsys.psd2.xs2a.domain.consent.CreateConsentAuthorizationResponse;
import de.adorsys.psd2.xs2a.domain.consent.CreateConsentReq;
import de.adorsys.psd2.xs2a.domain.consent.CreateConsentResponse;
import de.adorsys.psd2.xs2a.domain.consent.UpdateConsentPsuDataReq;
import de.adorsys.psd2.xs2a.domain.consent.UpdateConsentPsuDataResponse;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aAccountAccess;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aAccountAccessType;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aCreatePisConsentCancellationAuthorisationResponse;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aPaymentCancellationAuthorisationSubResource;
import de.adorsys.psd2.xs2a.domain.consent.Xsa2CreatePisConsentAuthorisationResponse;
import de.adorsys.psd2.xs2a.domain.consent.pis.Xs2aUpdatePisConsentPsuDataRequest;
import de.adorsys.psd2.xs2a.domain.consent.pis.Xs2aUpdatePisConsentPsuDataResponse;
import de.adorsys.psd2.xs2a.exception.MessageCategory;
import de.adorsys.psd2.xs2a.exception.MessageError;
import de.adorsys.psd2.xs2a.service.TppService;
import de.adorsys.psd2.xs2a.service.authorization.AuthorisationMethodService;
import de.adorsys.psd2.xs2a.service.authorization.ais.AisAuthorizationService;
import de.adorsys.psd2.xs2a.service.authorization.pis.PisScaAuthorisationService;
import de.adorsys.psd2.xs2a.service.consent.AisConsentDataService;
import de.adorsys.psd2.xs2a.service.consent.PisPsuDataService;
import de.adorsys.psd2.xs2a.service.consent.Xs2aAisConsentService;
import de.adorsys.psd2.xs2a.service.event.Xs2aEventService;
import de.adorsys.psd2.xs2a.service.mapper.consent.Xs2aAisConsentMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiResponseStatusToXs2aMessageErrorCodeMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.Xs2aToSpiPsuDataMapper;
import de.adorsys.psd2.xs2a.service.profile.AspspProfileServiceWrapper;
import de.adorsys.psd2.xs2a.service.validator.CreateConsentRequestValidator;
import de.adorsys.psd2.xs2a.service.validator.ValidationResult;
import de.adorsys.psd2.xs2a.spi.domain.psu.SpiPsuData;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import de.adorsys.psd2.xs2a.spi.service.AisConsentSpi;
import java.beans.ConstructorProperties;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class ConsentService {
    private final Xs2aAisConsentMapper aisConsentMapper;
    private final Xs2aToSpiPsuDataMapper psuDataMapper;
    private final SpiResponseStatusToXs2aMessageErrorCodeMapper messageErrorCodeMapper;
    private final Xs2aAisConsentService aisConsentService;
    private final AisConsentDataService aisConsentDataService;
    private final AisAuthorizationService aisAuthorizationService;
    private final AspspProfileServiceWrapper aspspProfileService;
    private final PisScaAuthorisationService pisAuthorizationService;
    private final PisPsuDataService pisPsuDataService;
    private final TppService tppService;
    private final AuthorisationMethodService authorisationMethodService;
    private final AisConsentSpi aisConsentSpi;
    private final CreateConsentRequestValidator createConsentRequestValidator;
    private final Xs2aEventService xs2aEventService;

    public ResponseObject<CreateConsentResponse> createAccountConsentsWithResponse(CreateConsentReq request, PsuIdData psuData, boolean explicitPreferred) {
        String tppId;
        String consentId;
        this.xs2aEventService.recordTppRequest(EventType.CREATE_AIS_CONSENT_REQUEST_RECEIVED, request);
        ValidationResult validationResult = this.createConsentRequestValidator.validateRequest(request);
        if (validationResult.isNotValid()) {
            return ResponseObject.builder().fail(validationResult.getMessageError()).build();
        }
        if (this.isConsentGlobal(request) || this.isConsentForAllAvailableAccounts(request)) {
            request.setAccess(this.getAccessForGlobalOrAllAvailableAccountsConsent(request));
        }
        if (StringUtils.isBlank((CharSequence)(consentId = this.aisConsentService.createConsent(request, psuData, tppId = this.tppService.getTppId())))) {
            return ResponseObject.builder().fail(new MessageError(new TppMessageInformation(MessageCategory.ERROR, MessageErrorCode.RESOURCE_UNKNOWN_400))).build();
        }
        SpiPsuData spiPsuData = this.psuDataMapper.mapToSpiPsuData(psuData);
        AccountConsent accountConsent = this.getValidatedAccountConsent(consentId);
        SpiResponse initiateAisConsentSpiResponse = this.aisConsentSpi.initiateAisConsent(spiPsuData, this.aisConsentMapper.mapToSpiAccountConsent(accountConsent), this.aisConsentDataService.getAspspConsentDataByConsentId(consentId));
        this.aisConsentDataService.updateAspspConsentData(initiateAisConsentSpiResponse.getAspspConsentData());
        if (initiateAisConsentSpiResponse.hasError()) {
            this.aisConsentService.updateConsentStatus(consentId, ConsentStatus.REJECTED);
            return ResponseObject.builder().fail(new MessageError(new TppMessageInformation(MessageCategory.ERROR, this.messageErrorCodeMapper.mapToMessageErrorCode(initiateAisConsentSpiResponse.getResponseStatus())))).build();
        }
        ResponseObject<CreateConsentResponse> createConsentResponseObject = ResponseObject.builder().body(new CreateConsentResponse(ConsentStatus.RECEIVED.getValue(), consentId, null, null, null, null)).build();
        if (this.aspspProfileService.getScaApproach() == ScaApproach.EMBEDDED && this.authorisationMethodService.isImplicitMethod(explicitPreferred)) {
            this.proceedEmbeddedImplicitCaseForCreateConsent(createConsentResponseObject.getBody(), psuData, consentId);
        }
        return createConsentResponseObject;
    }

    public ResponseObject<ConsentStatusResponse> getAccountConsentsStatusById(String consentId) {
        this.xs2aEventService.recordAisTppRequest(consentId, EventType.GET_AIS_CONSENT_STATUS_REQUEST_RECEIVED);
        AccountConsent validatedAccountConsent = this.getValidatedAccountConsent(consentId);
        Optional<ConsentStatus> consentStatus = Optional.ofNullable(validatedAccountConsent).map(AccountConsent::getConsentStatus);
        ResponseObject.ResponseBuilder<Object> responseBuilder = ResponseObject.builder();
        responseBuilder = consentStatus.isPresent() ? responseBuilder.body(new ConsentStatusResponse(consentStatus.get())) : responseBuilder.fail(new MessageError(new TppMessageInformation(MessageCategory.ERROR, MessageErrorCode.CONSENT_UNKNOWN_400)));
        return responseBuilder.build();
    }

    public ResponseObject<Void> deleteAccountConsentsById(String consentId) {
        this.xs2aEventService.recordAisTppRequest(consentId, EventType.DELETE_AIS_CONSENT_REQUEST_RECEIVED);
        AccountConsent accountConsent = this.getValidatedAccountConsent(consentId);
        if (accountConsent != null) {
            SpiPsuData spiPsuData = this.psuDataMapper.mapToSpiPsuData(accountConsent.getPsuData());
            SpiResponse revokeAisConsentResponse = this.aisConsentSpi.revokeAisConsent(spiPsuData, this.aisConsentMapper.mapToSpiAccountConsent(accountConsent), this.aisConsentDataService.getAspspConsentDataByConsentId(consentId));
            this.aisConsentDataService.updateAspspConsentData(revokeAisConsentResponse.getAspspConsentData());
            if (revokeAisConsentResponse.hasError()) {
                return ResponseObject.builder().fail(new MessageError(new TppMessageInformation(MessageCategory.ERROR, this.messageErrorCodeMapper.mapToMessageErrorCode(revokeAisConsentResponse.getResponseStatus())))).build();
            }
            this.aisConsentService.revokeConsent(consentId);
            return ResponseObject.builder().build();
        }
        return ResponseObject.builder().fail(new MessageError(new TppMessageInformation(MessageCategory.ERROR, MessageErrorCode.CONSENT_UNKNOWN_400))).build();
    }

    public ResponseObject<AccountConsent> getAccountConsentById(String consentId) {
        this.xs2aEventService.recordAisTppRequest(consentId, EventType.GET_AIS_CONSENT_REQUEST_RECEIVED);
        AccountConsent consent = this.getValidatedAccountConsent(consentId);
        return consent == null ? ResponseObject.builder().fail(new MessageError(new TppMessageInformation(MessageCategory.ERROR, MessageErrorCode.CONSENT_UNKNOWN_400))).build() : ResponseObject.builder().body(consent).build();
    }

    ResponseObject<AccountConsent> getValidatedConsent(String consentId, boolean withBalance) {
        AccountConsent accountConsent = this.getValidatedAccountConsent(consentId);
        if (accountConsent == null) {
            return ResponseObject.builder().fail(new MessageError(new TppMessageInformation(MessageCategory.ERROR, MessageErrorCode.CONSENT_UNKNOWN_400))).build();
        }
        if (withBalance && !accountConsent.isWithBalance()) {
            return ResponseObject.builder().fail(new MessageError(new TppMessageInformation(MessageCategory.ERROR, MessageErrorCode.CONSENT_INVALID))).build();
        }
        if (LocalDate.now().compareTo(accountConsent.getValidUntil()) >= 0) {
            return ResponseObject.builder().fail(new MessageError(new TppMessageInformation(MessageCategory.ERROR, MessageErrorCode.CONSENT_EXPIRED))).build();
        }
        if (!accountConsent.isValidStatus()) {
            return ResponseObject.builder().fail(new MessageError(new TppMessageInformation(MessageCategory.ERROR, MessageErrorCode.CONSENT_EXPIRED))).build();
        }
        if (!accountConsent.isValidFrequency()) {
            return ResponseObject.builder().fail(new MessageError(new TppMessageInformation(MessageCategory.ERROR, MessageErrorCode.ACCESS_EXCEEDED))).build();
        }
        return ResponseObject.builder().body(accountConsent).build();
    }

    ResponseObject<AccountConsent> getValidatedConsent(String consentId) {
        return this.getValidatedConsent(consentId, false);
    }

    public ResponseObject<CreateConsentAuthorizationResponse> createConsentAuthorizationWithResponse(PsuIdData psuData, String consentId) {
        this.xs2aEventService.recordAisTppRequest(consentId, EventType.START_AIS_CONSENT_AUTHORISATION_REQUEST_RECEIVED);
        return this.aisAuthorizationService.createConsentAuthorization(psuData, consentId).map(resp -> ResponseObject.builder().body((CreateConsentAuthorizationResponse)resp).build()).orElseGet(ResponseObject.builder().fail(new MessageError(MessageErrorCode.CONSENT_UNKNOWN_400))::build);
    }

    public ResponseObject<UpdateConsentPsuDataResponse> updateConsentPsuData(UpdateConsentPsuDataReq updatePsuData) {
        this.xs2aEventService.recordAisTppRequest(updatePsuData.getConsentId(), EventType.UPDATE_AIS_CONSENT_PSU_DATA_REQUEST_RECEIVED, updatePsuData);
        return Optional.ofNullable(this.aisAuthorizationService.getAccountConsentAuthorizationById(updatePsuData.getAuthorizationId(), updatePsuData.getConsentId())).map(conAuth -> this.getUpdateConsentPsuDataResponse(updatePsuData, (AccountConsentAuthorization)conAuth)).orElseGet(ResponseObject.builder().fail(new MessageError(MessageErrorCode.RESOURCE_UNKNOWN_404))::build);
    }

    private ResponseObject<UpdateConsentPsuDataResponse> getUpdateConsentPsuDataResponse(UpdateConsentPsuDataReq updatePsuData, AccountConsentAuthorization consentAuthorization) {
        UpdateConsentPsuDataResponse response = this.aisAuthorizationService.updateConsentPsuData(updatePsuData, consentAuthorization);
        return Optional.ofNullable(response).map(s -> Optional.ofNullable(s.getErrorCode()).map(e -> ResponseObject.builder().fail(new MessageError((MessageErrorCode)((Object)((Object)e)))).build()).orElseGet(ResponseObject.builder().body(response)::build)).orElseGet(ResponseObject.builder().fail(new MessageError(MessageErrorCode.FORMAT_ERROR))::build);
    }

    public ResponseObject<Xsa2CreatePisConsentAuthorisationResponse> createPisConsentAuthorization(String paymentId, PaymentType paymentType, PsuIdData psuData) {
        this.xs2aEventService.recordPisTppRequest(paymentId, EventType.START_PAYMENT_AUTHORISATION_REQUEST_RECEIVED);
        return this.pisAuthorizationService.createConsentAuthorisation(paymentId, paymentType, psuData).map(resp -> ResponseObject.builder().body((Xsa2CreatePisConsentAuthorisationResponse)resp).build()).orElseGet(ResponseObject.builder().fail(new MessageError(MessageErrorCode.PAYMENT_FAILED))::build);
    }

    public ResponseObject<Xs2aUpdatePisConsentPsuDataResponse> updatePisConsentPsuData(Xs2aUpdatePisConsentPsuDataRequest request) {
        this.xs2aEventService.recordPisTppRequest(request.getPaymentId(), EventType.UPDATE_PAYMENT_AUTHORISATION_PSU_DATA_REQUEST_RECEIVED, request);
        Xs2aUpdatePisConsentPsuDataResponse response = this.pisAuthorizationService.updateConsentPsuData(request);
        if (response.hasError()) {
            return ResponseObject.builder().fail(new MessageError(response.getErrorHolder().getErrorCode(), response.getErrorHolder().getMessage())).build();
        }
        return ResponseObject.builder().body(response).build();
    }

    public ResponseObject<Xs2aCreatePisConsentCancellationAuthorisationResponse> createPisConsentCancellationAuthorization(String paymentId, PaymentType paymentType) {
        this.xs2aEventService.recordPisTppRequest(paymentId, EventType.START_PAYMENT_CANCELLATION_AUTHORISATION_REQUEST_RECEIVED);
        PsuIdData psuData = this.pisPsuDataService.getPsuDataByPaymentId(paymentId);
        return this.pisAuthorizationService.createConsentCancellationAuthorisation(paymentId, paymentType, psuData).map(resp -> ResponseObject.builder().body((Xs2aCreatePisConsentCancellationAuthorisationResponse)resp).build()).orElseGet(ResponseObject.builder().fail(new MessageError(MessageErrorCode.FORMAT_ERROR))::build);
    }

    public ResponseObject<Xs2aUpdatePisConsentPsuDataResponse> updatePisConsentCancellationPsuData(Xs2aUpdatePisConsentPsuDataRequest request) {
        this.xs2aEventService.recordPisTppRequest(request.getPaymentId(), EventType.UPDATE_PAYMENT_CANCELLATION_PSU_DATA_REQUEST_RECEIVED, request);
        Xs2aUpdatePisConsentPsuDataResponse response = this.pisAuthorizationService.updateConsentCancellationPsuData(request);
        if (response.hasError()) {
            return ResponseObject.builder().fail(new MessageError(response.getErrorHolder().getErrorCode(), response.getErrorHolder().getMessage())).build();
        }
        return ResponseObject.builder().body(response).build();
    }

    public ResponseObject<Xs2aPaymentCancellationAuthorisationSubResource> getPaymentInitiationCancellationAuthorisationInformation(String paymentId) {
        this.xs2aEventService.recordPisTppRequest(paymentId, EventType.GET_PAYMENT_CANCELLATION_AUTHORISATION_REQUEST_RECEIVED);
        return this.pisAuthorizationService.getCancellationAuthorisationSubResources(paymentId).map(resp -> ResponseObject.builder().body((Xs2aPaymentCancellationAuthorisationSubResource)resp).build()).orElseGet(ResponseObject.builder().fail(new MessageError(MessageErrorCode.RESOURCE_UNKNOWN_404))::build);
    }

    boolean isValidAccountByAccess(String resourceId, List<Xs2aAccountReference> allowedAccountData) {
        return CollectionUtils.isNotEmpty(allowedAccountData) && allowedAccountData.stream().anyMatch(a -> a.getResourceId().equals(resourceId));
    }

    private boolean isNotEmptyAccess(Xs2aAccountAccess access) {
        return Optional.ofNullable(access).map(Xs2aAccountAccess::isNotEmpty).orElse(false);
    }

    private boolean isConsentGlobal(CreateConsentReq request) {
        return this.isNotEmptyAccess(request.getAccess()) && request.getAccess().getAllPsd2() == Xs2aAccountAccessType.ALL_ACCOUNTS;
    }

    private boolean isConsentForAllAvailableAccounts(CreateConsentReq request) {
        return request.getAccess().getAvailableAccounts() == Xs2aAccountAccessType.ALL_ACCOUNTS || request.getAccess().getAvailableAccounts() == Xs2aAccountAccessType.ALL_ACCOUNTS_WITH_BALANCES;
    }

    private Xs2aAccountAccess getAccessForGlobalOrAllAvailableAccountsConsent(CreateConsentReq request) {
        return new Xs2aAccountAccess(new ArrayList<Xs2aAccountReference>(), new ArrayList<Xs2aAccountReference>(), new ArrayList<Xs2aAccountReference>(), request.getAccess().getAvailableAccounts(), request.getAccess().getAllPsd2());
    }

    private AccountConsent getValidatedAccountConsent(String consentId) {
        return Optional.ofNullable(this.aisConsentService.getAccountConsentById(consentId)).filter(consent -> this.tppService.getTppId().equals(consent.getTppId())).orElse(null);
    }

    private void proceedEmbeddedImplicitCaseForCreateConsent(CreateConsentResponse response, PsuIdData psuData, String consentId) {
        this.aisAuthorizationService.createConsentAuthorization(psuData, consentId).ifPresent(a -> response.setAuthorizationId(a.getAuthorizationId()));
    }

    @ConstructorProperties(value={"aisConsentMapper", "psuDataMapper", "messageErrorCodeMapper", "aisConsentService", "aisConsentDataService", "aisAuthorizationService", "aspspProfileService", "pisAuthorizationService", "pisPsuDataService", "tppService", "authorisationMethodService", "aisConsentSpi", "createConsentRequestValidator", "xs2aEventService"})
    public ConsentService(Xs2aAisConsentMapper aisConsentMapper, Xs2aToSpiPsuDataMapper psuDataMapper, SpiResponseStatusToXs2aMessageErrorCodeMapper messageErrorCodeMapper, Xs2aAisConsentService aisConsentService, AisConsentDataService aisConsentDataService, AisAuthorizationService aisAuthorizationService, AspspProfileServiceWrapper aspspProfileService, PisScaAuthorisationService pisAuthorizationService, PisPsuDataService pisPsuDataService, TppService tppService, AuthorisationMethodService authorisationMethodService, AisConsentSpi aisConsentSpi, CreateConsentRequestValidator createConsentRequestValidator, Xs2aEventService xs2aEventService) {
        this.aisConsentMapper = aisConsentMapper;
        this.psuDataMapper = psuDataMapper;
        this.messageErrorCodeMapper = messageErrorCodeMapper;
        this.aisConsentService = aisConsentService;
        this.aisConsentDataService = aisConsentDataService;
        this.aisAuthorizationService = aisAuthorizationService;
        this.aspspProfileService = aspspProfileService;
        this.pisAuthorizationService = pisAuthorizationService;
        this.pisPsuDataService = pisPsuDataService;
        this.tppService = tppService;
        this.authorisationMethodService = authorisationMethodService;
        this.aisConsentSpi = aisConsentSpi;
        this.createConsentRequestValidator = createConsentRequestValidator;
        this.xs2aEventService = xs2aEventService;
    }
}

