/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.exception;

import de.adorsys.psd2.aspsp.profile.exception.AspspProfileRestException;
import de.adorsys.psd2.model.TppMessages;
import de.adorsys.psd2.xs2a.domain.MessageErrorCode;
import de.adorsys.psd2.xs2a.exception.CertificateException;
import de.adorsys.psd2.xs2a.exception.RestException;
import de.adorsys.psd2.xs2a.service.mapper.MessageErrorMapper;
import java.beans.ConstructorProperties;
import javax.validation.ValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.ServletRequestBindingException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.method.HandlerMethod;

@RestControllerAdvice
public class GlobalExceptionHandlerController {
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandlerController.class);
    private final MessageErrorMapper messageErrorMapper;

    @ExceptionHandler(value={ValidationException.class})
    public ResponseEntity validationException(ValidationException ex, HandlerMethod handlerMethod) {
        log.warn("Validation exception handled in service: {}, message: {}", (Object)handlerMethod.getMethod().getDeclaringClass().getSimpleName(), (Object)ex.getMessage());
        return new ResponseEntity((Object)this.getTppMessages(MessageErrorCode.FORMAT_ERROR), HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={ServletRequestBindingException.class})
    public ResponseEntity servletRequestBindingException(ServletRequestBindingException ex, HandlerMethod handlerMethod) {
        log.warn("Validation exception handled in service: {}, message: {}", (Object)handlerMethod.getMethod().getDeclaringClass().getSimpleName(), (Object)ex.getMessage());
        return new ResponseEntity((Object)this.getTppMessages(MessageErrorCode.FORMAT_ERROR), HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    public ResponseEntity illegalArgumentException(IllegalArgumentException ex, HandlerMethod handlerMethod) {
        log.warn("Illegal argument exception handled in: {}, message: {}", (Object)handlerMethod.getMethod().getDeclaringClass().getSimpleName(), (Object)ex.getMessage());
        log.debug("Stacktrace: {}", (Throwable)ex);
        return new ResponseEntity((Object)this.getTppMessages(MessageErrorCode.FORMAT_ERROR), HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    public ResponseEntity httpMessageException(HttpMessageNotReadableException ex, HandlerMethod handlerMethod) {
        log.warn("Uncatched exception of HttpMessageNotReadableException class handled in Controller: {}, message: {}", (Object)handlerMethod.getMethod().getDeclaringClass().getSimpleName(), (Object)ex.getMessage());
        return new ResponseEntity((Object)this.getTppMessages(MessageErrorCode.FORMAT_ERROR), HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={HttpMediaTypeNotAcceptableException.class})
    public ResponseEntity mediaTypeNotSupportedException(HttpMediaTypeNotAcceptableException ex, HandlerMethod handlerMethod) {
        log.warn("Media type unsupported exception: {}, message: {}", (Object)handlerMethod.getMethod().getDeclaringClass().getSimpleName(), (Object)ex.getMessage());
        return new ResponseEntity((Object)HttpStatus.UNSUPPORTED_MEDIA_TYPE.getReasonPhrase(), HttpStatus.UNSUPPORTED_MEDIA_TYPE);
    }

    @ExceptionHandler(value={Exception.class})
    public ResponseEntity exception(Exception ex, HandlerMethod handlerMethod) {
        log.warn("Uncatched exception handled in Controller: {}, message: {}, stackTrace: {}", new Object[]{handlerMethod.getMethod().getDeclaringClass().getSimpleName(), ex.getMessage(), ex});
        return new ResponseEntity((Object)HttpStatus.INTERNAL_SERVER_ERROR.getReasonPhrase(), HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @ExceptionHandler(value={RestException.class})
    public ResponseEntity restException(RestException ex, HandlerMethod handlerMethod) {
        log.warn("RestException handled in service: {}, message: {}", (Object)handlerMethod.getMethod().getDeclaringClass().getSimpleName(), (Object)ex.getMessage());
        log.debug("Stacktrace: {}", (Throwable)ex);
        return new ResponseEntity((Object)this.getTppMessages(ex.getMessageErrorCode()), ex.getHttpStatus());
    }

    @ExceptionHandler(value={AspspProfileRestException.class})
    public ResponseEntity aspspProfileRestException(AspspProfileRestException ex, HandlerMethod handlerMethod) {
        log.warn("RestException handled in service: {}, message: {}", (Object)handlerMethod.getMethod().getDeclaringClass().getSimpleName(), (Object)ex.getMessage());
        log.debug("Stacktrace: {}", (Throwable)ex);
        return new ResponseEntity((Object)this.getTppMessages(MessageErrorCode.INTERNAL_SERVER_ERROR), HttpStatus.valueOf((int)ex.getHttpStatusCode()));
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public ResponseEntity requestBodyValidationException(MethodArgumentNotValidException ex, HandlerMethod handlerMethod) {
        log.warn("RequestBodyValidationException handled in controller: {}, message: {} ", (Object)handlerMethod.getMethod().getDeclaringClass().getSimpleName(), (Object)ex.getMessage());
        log.debug("Stacktrace: {}", (Throwable)ex);
        return new ResponseEntity((Object)this.getTppMessages(MessageErrorCode.FORMAT_ERROR), HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={CertificateException.class})
    public ResponseEntity getTppIdException(CertificateException ex, HandlerMethod handlerMethod) {
        log.warn("Can't find tpp id in SecurityContextHolder in: {}, message: {}", (Object)handlerMethod.getMethod().getDeclaringClass().getSimpleName(), (Object)ex.getMessage());
        log.debug("Stacktrace: {}", (Throwable)ex);
        return new ResponseEntity((Object)this.getTppMessages(MessageErrorCode.CERTIFICATE_INVALID), HttpStatus.BAD_REQUEST);
    }

    private TppMessages getTppMessages(MessageErrorCode errorCode) {
        return this.messageErrorMapper.mapToTppMessages(errorCode);
    }

    @ConstructorProperties(value={"messageErrorMapper"})
    public GlobalExceptionHandlerController(MessageErrorMapper messageErrorMapper) {
        this.messageErrorMapper = messageErrorMapper;
    }
}

