/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.domain.pis;

import de.adorsys.psd2.xs2a.domain.code.Xs2aFrequencyCode;
import de.adorsys.psd2.xs2a.domain.pis.SinglePayment;
import java.time.LocalDate;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

public class PeriodicPayment
extends SinglePayment {
    @NotNull
    private LocalDate startDate;
    private String executionRule;
    private LocalDate endDate;
    @NotNull
    private Xs2aFrequencyCode frequency;
    @Min(value=1L)
    @Max(value=31L)
    private @Min(value=1L) @Max(value=31L) int dayOfExecution;

    public LocalDate getStartDate() {
        return this.startDate;
    }

    public String getExecutionRule() {
        return this.executionRule;
    }

    public LocalDate getEndDate() {
        return this.endDate;
    }

    public Xs2aFrequencyCode getFrequency() {
        return this.frequency;
    }

    public int getDayOfExecution() {
        return this.dayOfExecution;
    }

    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    public void setExecutionRule(String executionRule) {
        this.executionRule = executionRule;
    }

    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    public void setFrequency(Xs2aFrequencyCode frequency) {
        this.frequency = frequency;
    }

    public void setDayOfExecution(int dayOfExecution) {
        this.dayOfExecution = dayOfExecution;
    }

    @Override
    public String toString() {
        return "PeriodicPayment(startDate=" + this.getStartDate() + ", executionRule=" + this.getExecutionRule() + ", endDate=" + this.getEndDate() + ", frequency=" + (Object)((Object)this.getFrequency()) + ", dayOfExecution=" + this.getDayOfExecution() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PeriodicPayment)) {
            return false;
        }
        PeriodicPayment other = (PeriodicPayment)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LocalDate this$startDate = this.getStartDate();
        LocalDate other$startDate = other.getStartDate();
        if (this$startDate == null ? other$startDate != null : !((Object)this$startDate).equals(other$startDate)) {
            return false;
        }
        String this$executionRule = this.getExecutionRule();
        String other$executionRule = other.getExecutionRule();
        if (this$executionRule == null ? other$executionRule != null : !this$executionRule.equals(other$executionRule)) {
            return false;
        }
        LocalDate this$endDate = this.getEndDate();
        LocalDate other$endDate = other.getEndDate();
        if (this$endDate == null ? other$endDate != null : !((Object)this$endDate).equals(other$endDate)) {
            return false;
        }
        Xs2aFrequencyCode this$frequency = this.getFrequency();
        Xs2aFrequencyCode other$frequency = other.getFrequency();
        if (this$frequency == null ? other$frequency != null : !((Object)((Object)this$frequency)).equals((Object)other$frequency)) {
            return false;
        }
        return this.getDayOfExecution() == other.getDayOfExecution();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof PeriodicPayment;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        LocalDate $startDate = this.getStartDate();
        result = result * 59 + ($startDate == null ? 43 : ((Object)$startDate).hashCode());
        String $executionRule = this.getExecutionRule();
        result = result * 59 + ($executionRule == null ? 43 : $executionRule.hashCode());
        LocalDate $endDate = this.getEndDate();
        result = result * 59 + ($endDate == null ? 43 : ((Object)$endDate).hashCode());
        Xs2aFrequencyCode $frequency = this.getFrequency();
        result = result * 59 + ($frequency == null ? 43 : ((Object)((Object)$frequency)).hashCode());
        result = result * 59 + this.getDayOfExecution();
        return result;
    }
}

