/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.domain.pis;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import de.adorsys.psd2.xs2a.core.pis.TransactionStatus;
import de.adorsys.psd2.xs2a.core.profile.PaymentType;
import de.adorsys.psd2.xs2a.core.sca.ChallengeData;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import de.adorsys.psd2.xs2a.domain.ErrorHolder;
import de.adorsys.psd2.xs2a.domain.Links;
import de.adorsys.psd2.xs2a.domain.MessageErrorCode;
import de.adorsys.psd2.xs2a.domain.Xs2aAmount;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aAuthenticationObject;
import java.util.Arrays;

public abstract class PaymentInitiationResponse {
    private ScaStatus scaStatus;
    @JsonUnwrapped
    private TransactionStatus transactionStatus;
    private Xs2aAmount transactionFees;
    private boolean transactionFeeIndicator;
    private String paymentId;
    private Xs2aAuthenticationObject[] scaMethods;
    private ChallengeData challengeData;
    private String psuMessage;
    private MessageErrorCode[] tppMessages;
    @JsonProperty(value="_links")
    private Links links;
    private String pisConsentId;
    private String authorizationId;
    private ErrorHolder errorHolder;

    PaymentInitiationResponse(ErrorHolder errorHolder) {
        this.errorHolder = errorHolder;
    }

    public boolean hasError() {
        return this.errorHolder != null;
    }

    abstract PaymentType getPaymentType();

    public ScaStatus getScaStatus() {
        return this.scaStatus;
    }

    public TransactionStatus getTransactionStatus() {
        return this.transactionStatus;
    }

    public Xs2aAmount getTransactionFees() {
        return this.transactionFees;
    }

    public boolean isTransactionFeeIndicator() {
        return this.transactionFeeIndicator;
    }

    public String getPaymentId() {
        return this.paymentId;
    }

    public Xs2aAuthenticationObject[] getScaMethods() {
        return this.scaMethods;
    }

    public ChallengeData getChallengeData() {
        return this.challengeData;
    }

    public String getPsuMessage() {
        return this.psuMessage;
    }

    public MessageErrorCode[] getTppMessages() {
        return this.tppMessages;
    }

    public Links getLinks() {
        return this.links;
    }

    public String getPisConsentId() {
        return this.pisConsentId;
    }

    public String getAuthorizationId() {
        return this.authorizationId;
    }

    public ErrorHolder getErrorHolder() {
        return this.errorHolder;
    }

    public void setScaStatus(ScaStatus scaStatus) {
        this.scaStatus = scaStatus;
    }

    public void setTransactionStatus(TransactionStatus transactionStatus) {
        this.transactionStatus = transactionStatus;
    }

    public void setTransactionFees(Xs2aAmount transactionFees) {
        this.transactionFees = transactionFees;
    }

    public void setTransactionFeeIndicator(boolean transactionFeeIndicator) {
        this.transactionFeeIndicator = transactionFeeIndicator;
    }

    public void setPaymentId(String paymentId) {
        this.paymentId = paymentId;
    }

    public void setScaMethods(Xs2aAuthenticationObject[] scaMethods) {
        this.scaMethods = scaMethods;
    }

    public void setChallengeData(ChallengeData challengeData) {
        this.challengeData = challengeData;
    }

    public void setPsuMessage(String psuMessage) {
        this.psuMessage = psuMessage;
    }

    public void setTppMessages(MessageErrorCode[] tppMessages) {
        this.tppMessages = tppMessages;
    }

    public void setLinks(Links links) {
        this.links = links;
    }

    public void setPisConsentId(String pisConsentId) {
        this.pisConsentId = pisConsentId;
    }

    public void setAuthorizationId(String authorizationId) {
        this.authorizationId = authorizationId;
    }

    public void setErrorHolder(ErrorHolder errorHolder) {
        this.errorHolder = errorHolder;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PaymentInitiationResponse)) {
            return false;
        }
        PaymentInitiationResponse other = (PaymentInitiationResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ScaStatus this$scaStatus = this.getScaStatus();
        ScaStatus other$scaStatus = other.getScaStatus();
        if (this$scaStatus == null ? other$scaStatus != null : !this$scaStatus.equals(other$scaStatus)) {
            return false;
        }
        TransactionStatus this$transactionStatus = this.getTransactionStatus();
        TransactionStatus other$transactionStatus = other.getTransactionStatus();
        if (this$transactionStatus == null ? other$transactionStatus != null : !this$transactionStatus.equals(other$transactionStatus)) {
            return false;
        }
        Xs2aAmount this$transactionFees = this.getTransactionFees();
        Xs2aAmount other$transactionFees = other.getTransactionFees();
        if (this$transactionFees == null ? other$transactionFees != null : !((Object)this$transactionFees).equals(other$transactionFees)) {
            return false;
        }
        if (this.isTransactionFeeIndicator() != other.isTransactionFeeIndicator()) {
            return false;
        }
        String this$paymentId = this.getPaymentId();
        String other$paymentId = other.getPaymentId();
        if (this$paymentId == null ? other$paymentId != null : !this$paymentId.equals(other$paymentId)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getScaMethods(), other.getScaMethods())) {
            return false;
        }
        ChallengeData this$challengeData = this.getChallengeData();
        ChallengeData other$challengeData = other.getChallengeData();
        if (this$challengeData == null ? other$challengeData != null : !this$challengeData.equals(other$challengeData)) {
            return false;
        }
        String this$psuMessage = this.getPsuMessage();
        String other$psuMessage = other.getPsuMessage();
        if (this$psuMessage == null ? other$psuMessage != null : !this$psuMessage.equals(other$psuMessage)) {
            return false;
        }
        if (!Arrays.deepEquals((Object[])this.getTppMessages(), (Object[])other.getTppMessages())) {
            return false;
        }
        Links this$links = this.getLinks();
        Links other$links = other.getLinks();
        if (this$links == null ? other$links != null : !((Object)this$links).equals(other$links)) {
            return false;
        }
        String this$pisConsentId = this.getPisConsentId();
        String other$pisConsentId = other.getPisConsentId();
        if (this$pisConsentId == null ? other$pisConsentId != null : !this$pisConsentId.equals(other$pisConsentId)) {
            return false;
        }
        String this$authorizationId = this.getAuthorizationId();
        String other$authorizationId = other.getAuthorizationId();
        if (this$authorizationId == null ? other$authorizationId != null : !this$authorizationId.equals(other$authorizationId)) {
            return false;
        }
        ErrorHolder this$errorHolder = this.getErrorHolder();
        ErrorHolder other$errorHolder = other.getErrorHolder();
        return !(this$errorHolder == null ? other$errorHolder != null : !this$errorHolder.equals(other$errorHolder));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PaymentInitiationResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ScaStatus $scaStatus = this.getScaStatus();
        result = result * 59 + ($scaStatus == null ? 43 : $scaStatus.hashCode());
        TransactionStatus $transactionStatus = this.getTransactionStatus();
        result = result * 59 + ($transactionStatus == null ? 43 : $transactionStatus.hashCode());
        Xs2aAmount $transactionFees = this.getTransactionFees();
        result = result * 59 + ($transactionFees == null ? 43 : ((Object)$transactionFees).hashCode());
        result = result * 59 + (this.isTransactionFeeIndicator() ? 79 : 97);
        String $paymentId = this.getPaymentId();
        result = result * 59 + ($paymentId == null ? 43 : $paymentId.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getScaMethods());
        ChallengeData $challengeData = this.getChallengeData();
        result = result * 59 + ($challengeData == null ? 43 : $challengeData.hashCode());
        String $psuMessage = this.getPsuMessage();
        result = result * 59 + ($psuMessage == null ? 43 : $psuMessage.hashCode());
        result = result * 59 + Arrays.deepHashCode((Object[])this.getTppMessages());
        Links $links = this.getLinks();
        result = result * 59 + ($links == null ? 43 : ((Object)$links).hashCode());
        String $pisConsentId = this.getPisConsentId();
        result = result * 59 + ($pisConsentId == null ? 43 : $pisConsentId.hashCode());
        String $authorizationId = this.getAuthorizationId();
        result = result * 59 + ($authorizationId == null ? 43 : $authorizationId.hashCode());
        ErrorHolder $errorHolder = this.getErrorHolder();
        result = result * 59 + ($errorHolder == null ? 43 : $errorHolder.hashCode());
        return result;
    }

    public String toString() {
        return "PaymentInitiationResponse(scaStatus=" + this.getScaStatus() + ", transactionStatus=" + this.getTransactionStatus() + ", transactionFees=" + this.getTransactionFees() + ", transactionFeeIndicator=" + this.isTransactionFeeIndicator() + ", paymentId=" + this.getPaymentId() + ", scaMethods=" + Arrays.deepToString(this.getScaMethods()) + ", challengeData=" + this.getChallengeData() + ", psuMessage=" + this.getPsuMessage() + ", tppMessages=" + Arrays.deepToString((Object[])this.getTppMessages()) + ", links=" + this.getLinks() + ", pisConsentId=" + this.getPisConsentId() + ", authorizationId=" + this.getAuthorizationId() + ", errorHolder=" + this.getErrorHolder() + ")";
    }

    public PaymentInitiationResponse() {
    }
}

