/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.domain.consent;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.adorsys.psd2.xs2a.domain.account.Xs2aAccountReference;
import de.adorsys.psd2.xs2a.domain.consent.Xs2aAccountAccessType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.beans.ConstructorProperties;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;

@ApiModel(description="Account access", value="AccountAccess")
public final class Xs2aAccountAccess {
    @ApiModelProperty(value="detailed account information", required=false)
    private final List<Xs2aAccountReference> accounts;
    @ApiModelProperty(value="balances of the addressed accounts", required=false)
    private final List<Xs2aAccountReference> balances;
    @ApiModelProperty(value="transactions of the addressed accounts", required=false)
    private final List<Xs2aAccountReference> transactions;
    @ApiModelProperty(value="only the value 'allAccounts' or 'allAccountsWithBalances' is admitted", example="allAccounts", required=false)
    private final Xs2aAccountAccessType availableAccounts;
    @ApiModelProperty(value="only the value 'allAccounts' is admitted", example="allAccounts", required=false)
    private final Xs2aAccountAccessType allPsd2;

    @JsonIgnore
    public boolean isNotEmpty() {
        return !CollectionUtils.isEmpty(this.accounts) || !CollectionUtils.isEmpty(this.balances) || !CollectionUtils.isEmpty(this.transactions) || this.allPsd2 != null || this.availableAccounts != null;
    }

    @ConstructorProperties(value={"accounts", "balances", "transactions", "availableAccounts", "allPsd2"})
    public Xs2aAccountAccess(List<Xs2aAccountReference> accounts, List<Xs2aAccountReference> balances, List<Xs2aAccountReference> transactions, Xs2aAccountAccessType availableAccounts, Xs2aAccountAccessType allPsd2) {
        this.accounts = accounts;
        this.balances = balances;
        this.transactions = transactions;
        this.availableAccounts = availableAccounts;
        this.allPsd2 = allPsd2;
    }

    public List<Xs2aAccountReference> getAccounts() {
        return this.accounts;
    }

    public List<Xs2aAccountReference> getBalances() {
        return this.balances;
    }

    public List<Xs2aAccountReference> getTransactions() {
        return this.transactions;
    }

    public Xs2aAccountAccessType getAvailableAccounts() {
        return this.availableAccounts;
    }

    public Xs2aAccountAccessType getAllPsd2() {
        return this.allPsd2;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Xs2aAccountAccess)) {
            return false;
        }
        Xs2aAccountAccess other = (Xs2aAccountAccess)o;
        List<Xs2aAccountReference> this$accounts = this.getAccounts();
        List<Xs2aAccountReference> other$accounts = other.getAccounts();
        if (this$accounts == null ? other$accounts != null : !((Object)this$accounts).equals(other$accounts)) {
            return false;
        }
        List<Xs2aAccountReference> this$balances = this.getBalances();
        List<Xs2aAccountReference> other$balances = other.getBalances();
        if (this$balances == null ? other$balances != null : !((Object)this$balances).equals(other$balances)) {
            return false;
        }
        List<Xs2aAccountReference> this$transactions = this.getTransactions();
        List<Xs2aAccountReference> other$transactions = other.getTransactions();
        if (this$transactions == null ? other$transactions != null : !((Object)this$transactions).equals(other$transactions)) {
            return false;
        }
        Xs2aAccountAccessType this$availableAccounts = this.getAvailableAccounts();
        Xs2aAccountAccessType other$availableAccounts = other.getAvailableAccounts();
        if (this$availableAccounts == null ? other$availableAccounts != null : !((Object)((Object)this$availableAccounts)).equals((Object)other$availableAccounts)) {
            return false;
        }
        Xs2aAccountAccessType this$allPsd2 = this.getAllPsd2();
        Xs2aAccountAccessType other$allPsd2 = other.getAllPsd2();
        return !(this$allPsd2 == null ? other$allPsd2 != null : !((Object)((Object)this$allPsd2)).equals((Object)other$allPsd2));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Xs2aAccountReference> $accounts = this.getAccounts();
        result = result * 59 + ($accounts == null ? 43 : ((Object)$accounts).hashCode());
        List<Xs2aAccountReference> $balances = this.getBalances();
        result = result * 59 + ($balances == null ? 43 : ((Object)$balances).hashCode());
        List<Xs2aAccountReference> $transactions = this.getTransactions();
        result = result * 59 + ($transactions == null ? 43 : ((Object)$transactions).hashCode());
        Xs2aAccountAccessType $availableAccounts = this.getAvailableAccounts();
        result = result * 59 + ($availableAccounts == null ? 43 : ((Object)((Object)$availableAccounts)).hashCode());
        Xs2aAccountAccessType $allPsd2 = this.getAllPsd2();
        result = result * 59 + ($allPsd2 == null ? 43 : ((Object)((Object)$allPsd2)).hashCode());
        return result;
    }

    public String toString() {
        return "Xs2aAccountAccess(accounts=" + this.getAccounts() + ", balances=" + this.getBalances() + ", transactions=" + this.getTransactions() + ", availableAccounts=" + (Object)((Object)this.getAvailableAccounts()) + ", allPsd2=" + (Object)((Object)this.getAllPsd2()) + ")";
    }
}

