/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.domain.account;

import de.adorsys.psd2.xs2a.domain.account.Xs2aAccountReference;
import java.util.Optional;
import org.apache.commons.validator.routines.CreditCardValidator;
import org.apache.commons.validator.routines.IBANValidator;

public enum SupportedAccountReferenceField {
    IBAN{

        @Override
        public Optional<Boolean> isValid(Xs2aAccountReference reference) {
            return Optional.ofNullable(reference.getIban()).map(x$0 -> SupportedAccountReferenceField.isValidIban(x$0));
        }
    }
    ,
    BBAN{

        @Override
        public Optional<Boolean> isValid(Xs2aAccountReference reference) {
            return Optional.ofNullable(reference.getBban()).map(x$0 -> SupportedAccountReferenceField.isValidBban(x$0));
        }
    }
    ,
    PAN{

        @Override
        public Optional<Boolean> isValid(Xs2aAccountReference reference) {
            return Optional.ofNullable(reference.getPan()).map(x$0 -> SupportedAccountReferenceField.isValidPan(x$0));
        }
    }
    ,
    MASKEDPAN{

        @Override
        public Optional<Boolean> isValid(Xs2aAccountReference reference) {
            return Optional.ofNullable(reference.getMaskedPan()).map(x$0 -> SupportedAccountReferenceField.isValidMaskedPan(x$0));
        }
    }
    ,
    MSISDN{

        @Override
        public Optional<Boolean> isValid(Xs2aAccountReference reference) {
            return Optional.ofNullable(reference.getMsisdn()).map(x$0 -> SupportedAccountReferenceField.isValidMsisdn(x$0));
        }
    };


    public abstract Optional<Boolean> isValid(Xs2aAccountReference var1);

    private static boolean isValidIban(String iban) {
        IBANValidator validator = IBANValidator.getInstance();
        return validator.isValid(SupportedAccountReferenceField.normalizeString(iban));
    }

    private static boolean isValidBban(String bban) {
        return SupportedAccountReferenceField.normalizeString(bban).length() >= 11 && SupportedAccountReferenceField.normalizeString(bban).length() <= 28;
    }

    private static boolean isValidPan(String pan) {
        CreditCardValidator validator = CreditCardValidator.genericCreditCardValidator();
        return validator.isValid(SupportedAccountReferenceField.normalizeString(pan));
    }

    private static boolean isValidMaskedPan(String maskedPan) {
        return maskedPan.replaceAll("[- ]", "").length() >= 14 && maskedPan.replaceAll("[- ]", "").length() <= 16;
    }

    private static boolean isValidMsisdn(String msisdn) {
        String tel = msisdn.replaceAll("[-() ]", "");
        return tel.matches("[\u02c6+]?[0-9]{8,15}") || tel.matches("[\u02c600]?[0-9]{8,16}");
    }

    private static String normalizeString(String string) {
        return string.replaceAll("[^a-zA-Z0-9]", "");
    }
}

