/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.domain;

import de.adorsys.psd2.xs2a.domain.MessageErrorCode;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;

public class ErrorHolder {
    private final List<String> messages;
    private final MessageErrorCode errorCode;

    private ErrorHolder(ErrorHolderBuilder builder) {
        this.messages = builder.messages;
        this.errorCode = builder.errorCode;
    }

    public String getMessage() {
        if (CollectionUtils.isEmpty(this.messages)) {
            return "";
        }
        return String.join((CharSequence)", ", this.messages);
    }

    public MessageErrorCode getErrorCode() {
        return this.errorCode;
    }

    public static ErrorHolderBuilder builder(MessageErrorCode errorCode) {
        return new ErrorHolderBuilder(errorCode);
    }

    public static class ErrorHolderBuilder {
        private List<String> messages;
        private MessageErrorCode errorCode;

        private ErrorHolderBuilder(MessageErrorCode errorCode) {
            this.errorCode = errorCode;
        }

        public ErrorHolderBuilder messages(List<String> messages) {
            this.messages = messages;
            return this;
        }

        public ErrorHolder build() {
            return new ErrorHolder(this);
        }
    }
}

