/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.domain;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

@ApiModel(description="CashAccountType", value="Cash Account Type")
public enum CashAccountType {
    CACC("Current"),
    CASH("CashPayment"),
    CHAR("Charges"),
    CISH("CashIncome"),
    COMM("Commission"),
    CPAC("ClearingParticipantSettlementAccount"),
    LLSV("LimitedLiquiditySavingsAccount"),
    LOAN("Loan"),
    MGLD("Marginal Lending"),
    MOMA("Money Market"),
    NREX("NonResidentExternal"),
    ODFT("Overdraft"),
    ONDP("OverNightDeposit"),
    OTHR("OtherAccount"),
    SACC("Settlement"),
    SLRY("Salary"),
    SVGS("Savings"),
    TAXE("Tax"),
    TRAN("TransactingAccount"),
    TRAS("Cash Trading");

    private static final Map<String, CashAccountType> container;
    private String value;

    @JsonCreator
    private CashAccountType(String value) {
        this.value = value;
    }

    @JsonIgnore
    public static Optional<CashAccountType> getByValue(String name) {
        return Optional.ofNullable(container.get(name));
    }

    public String getValue() {
        return this.value;
    }

    static {
        container = new HashMap<String, CashAccountType>();
        for (CashAccountType cashAccountType : CashAccountType.values()) {
            container.put(cashAccountType.getValue(), cashAccountType);
        }
    }
}

