/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.config;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import de.adorsys.psd2.xs2a.component.DateTimeDeserializer;
import de.adorsys.psd2.xs2a.component.PaymentTypeEnumConverter;
import de.adorsys.psd2.xs2a.config.CorsConfigProperties;
import de.adorsys.psd2.xs2a.service.TppService;
import de.adorsys.psd2.xs2a.service.mapper.MessageErrorMapper;
import de.adorsys.psd2.xs2a.service.message.MessageService;
import de.adorsys.psd2.xs2a.service.validator.RequestValidatorService;
import de.adorsys.psd2.xs2a.service.validator.parameter.ParametersFactory;
import de.adorsys.psd2.xs2a.web.interceptor.HandlerInterceptor;
import de.adorsys.psd2.xs2a.web.interceptor.logging.AccountLoggingInterceptor;
import de.adorsys.psd2.xs2a.web.interceptor.logging.ConsentLoggingInterceptor;
import de.adorsys.psd2.xs2a.web.interceptor.logging.FundsConfirmationLoggingInterceptor;
import de.adorsys.psd2.xs2a.web.interceptor.logging.PaymentLoggingInterceptor;
import de.adorsys.psd2.xs2a.web.interceptor.logging.SigningBasketLoggingInterceptor;
import java.beans.ConstructorProperties;
import java.time.LocalDateTime;
import javax.servlet.Filter;
import javax.validation.Validation;
import javax.validation.Validator;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.context.annotation.Primary;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.format.FormatterRegistry;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.filter.CorsFilter;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@Configuration
@EnableAspectJAutoProxy(proxyTargetClass=true)
public class WebConfig
extends WebMvcConfigurerAdapter {
    @Value(value="${application.ais.transaction.max-length}")
    private int maxNumberOfCharInTransactionJson;
    private final CorsConfigProperties corsConfigProperties;
    private final TppService tppService;

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(new String[]{"swagger-ui.html"}).addResourceLocations(new String[]{"classpath:/META-INF/resources/"});
        registry.addResourceHandler(new String[]{"/webjars/**"}).addResourceLocations(new String[]{"classpath:/META-INF/resources/webjars/"});
    }

    @Bean
    public MessageSource messageSource() {
        ReloadableResourceBundleMessageSource messageSource = new ReloadableResourceBundleMessageSource();
        messageSource.setBasename("classpath:error_message");
        messageSource.setCacheSeconds(3600);
        messageSource.setDefaultEncoding("UTF-8");
        return messageSource;
    }

    @Bean
    @Primary
    public ObjectMapper objectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, true);
        objectMapper.registerModule((Module)this.getDateTimeDeserializerModule());
        objectMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        objectMapper.configure(SerializationFeature.WRITE_EMPTY_JSON_ARRAYS, false);
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        objectMapper.registerModule((Module)new Jdk8Module());
        objectMapper.registerModule((Module)new JavaTimeModule());
        objectMapper.registerModule((Module)new ParameterNamesModule());
        return objectMapper;
    }

    @Bean
    public ParametersFactory parametersFactory(ObjectMapper objectMapper) {
        return new ParametersFactory(objectMapper);
    }

    @Bean
    public RequestValidatorService requestValidatorService() {
        return new RequestValidatorService();
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((org.springframework.web.servlet.HandlerInterceptor)new AccountLoggingInterceptor(this.tppService)).addPathPatterns(new String[]{"/v1/accounts/**"});
        registry.addInterceptor((org.springframework.web.servlet.HandlerInterceptor)new ConsentLoggingInterceptor(this.tppService)).addPathPatterns(new String[]{"/v1/consents/**"});
        registry.addInterceptor((org.springframework.web.servlet.HandlerInterceptor)new FundsConfirmationLoggingInterceptor(this.tppService)).addPathPatterns(new String[]{"/v1/funds-confirmations/**"});
        registry.addInterceptor((org.springframework.web.servlet.HandlerInterceptor)new PaymentLoggingInterceptor(this.tppService)).addPathPatterns(new String[]{"/v1/payments/**", "/v1/bulk-payments/**", "/v1/periodic-payments/**"});
        registry.addInterceptor((org.springframework.web.servlet.HandlerInterceptor)new SigningBasketLoggingInterceptor(this.tppService)).addPathPatterns(new String[]{"/v1/signing-baskets/**"});
        registry.addInterceptor((org.springframework.web.servlet.HandlerInterceptor)new HandlerInterceptor(this.requestValidatorService(), this.objectMapper(), this.messageErrorMapper()));
    }

    @Bean
    public int maxNumberOfCharInTransactionJson() {
        return this.maxNumberOfCharInTransactionJson;
    }

    @Bean
    public Validator validator() {
        return Validation.buildDefaultValidatorFactory().getValidator();
    }

    @Bean
    public FilterRegistrationBean corsFilterRegistrationBean() {
        CorsConfiguration config = new CorsConfiguration();
        config.applyPermitDefaultValues();
        config.setAllowCredentials(this.corsConfigProperties.getAllowCredentials());
        config.setAllowedOrigins(this.corsConfigProperties.getAllowedOrigins());
        config.setAllowedHeaders(this.corsConfigProperties.getAllowedHeaders());
        config.setAllowedMethods(this.corsConfigProperties.getAllowedMethods());
        config.setMaxAge(this.corsConfigProperties.getMaxAge());
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        source.registerCorsConfiguration("/**", config);
        return new FilterRegistrationBean((Filter)new CorsFilter((CorsConfigurationSource)source), new ServletRegistrationBean[0]);
    }

    @Bean
    public MessageErrorMapper messageErrorMapper() {
        return new MessageErrorMapper(new MessageService(this.messageSource()));
    }

    public void addFormatters(FormatterRegistry registry) {
        registry.addConverter((GenericConverter)new PaymentTypeEnumConverter());
    }

    private SimpleModule getDateTimeDeserializerModule() {
        SimpleModule dateTimeModule = new SimpleModule();
        dateTimeModule.addDeserializer(LocalDateTime.class, (JsonDeserializer)new DateTimeDeserializer());
        return dateTimeModule;
    }

    @ConstructorProperties(value={"corsConfigProperties", "tppService"})
    public WebConfig(CorsConfigProperties corsConfigProperties, TppService tppService) {
        this.corsConfigProperties = corsConfigProperties;
        this.tppService = tppService;
    }
}

