/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.component;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TppLogger {
    private static final Logger log = LoggerFactory.getLogger((String)"access-log");

    public static TppLogBuilder logRequest() {
        return new TppLogBuilder(TppLogType.REQUEST);
    }

    public static TppLogBuilder logResponse() {
        return new TppLogBuilder(TppLogType.RESPONSE);
    }

    private static enum TppLogType {
        REQUEST,
        RESPONSE;

    }

    public static class TppLogBuilder {
        private Map<String, String> logParams = new LinkedHashMap<String, String>();
        private TppLogType tppLogType;

        private TppLogBuilder(TppLogType tppLogType) {
            this.tppLogType = tppLogType;
        }

        public TppLogBuilder withParam(String paramName, String paramValue) {
            this.logParams.put(paramName, paramValue);
            return this;
        }

        public void perform() {
            String logMessageParams = this.logParams.entrySet().stream().map(e -> (String)e.getKey() + ": [" + (String)e.getValue() + "]").collect(Collectors.joining(", "));
            log.info(this.tppLogType.name() + " - " + logMessageParams);
        }
    }
}

