/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.core.consent;

import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AspspConsentData {
    @Nullable
    private final byte[] aspspConsentDataBytes;
    @NotNull
    private final String consentId;

    public boolean isEmptyConsentData() {
        return this.aspspConsentDataBytes == null && StringUtils.isBlank((CharSequence)this.consentId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AspspConsentData that = (AspspConsentData)o;
        return Arrays.equals(this.aspspConsentDataBytes, that.aspspConsentDataBytes) && Objects.equals(this.consentId, that.getConsentId());
    }

    public int hashCode() {
        return Objects.hash(this.aspspConsentDataBytes, this.consentId);
    }

    @ConstructorProperties(value={"aspspConsentDataBytes", "consentId"})
    public AspspConsentData(@Nullable byte[] aspspConsentDataBytes, @NotNull String consentId) {
        if (consentId == null) {
            throw new NullPointerException("consentId is marked @NonNull but is null");
        }
        this.aspspConsentDataBytes = aspspConsentDataBytes;
        this.consentId = consentId;
    }

    @Nullable
    public byte[] getAspspConsentDataBytes() {
        return this.aspspConsentDataBytes;
    }

    @NotNull
    public String getConsentId() {
        return this.consentId;
    }

    public String toString() {
        return "AspspConsentData(aspspConsentDataBytes=" + Arrays.toString(this.getAspspConsentDataBytes()) + ", consentId=" + this.getConsentId() + ")";
    }
}

