/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.core.sca;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.adorsys.psd2.xs2a.core.sca.OtpFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

@ApiModel(description="Challenge data needed for SCA", value="ChallengeData")
public class ChallengeData {
    @ApiModelProperty(value="PNG data (max. 512 kilobyte) to be displayed to the PSU, Base64 encoding, cp. [RFC4648]. This attribute is used only, when PHOTO_OTP or CHIP_OTP is the selected SCA method.")
    private byte[] image;
    @ApiModelProperty(value="String challenge data", example="zzz")
    private List<String> data;
    @ApiModelProperty(value="A link where the ASPSP will provides the challenge image for the TPP", example="https://www.testbank.com/authentication/image.jpg")
    private String imageLink;
    @ApiModelProperty(value="The maximal length for the OTP to be typed in by the PSU", example="6")
    private Integer otpMaxLength;
    @ApiModelProperty(value="The format type of the OTP to be typed in. The admitted values are 'characters' or 'integer'.", example="integer")
    private OtpFormat otpFormat;
    @ApiModelProperty(value="Additional explanation for the PSU to explain e.g. fallback mechanism for the chosen SCA method. The TPP is obliged to show this to the PSU.", example="Additional information")
    private String additionalInformation;

    @JsonIgnore
    public boolean isEmpty() {
        return ArrayUtils.isEmpty((byte[])this.image) && CollectionUtils.isEmpty(this.data) && StringUtils.isBlank((CharSequence)this.imageLink) && this.otpMaxLength == null && this.otpFormat == null && StringUtils.isBlank((CharSequence)this.additionalInformation);
    }

    public byte[] getImage() {
        return this.image;
    }

    public List<String> getData() {
        return this.data;
    }

    public String getImageLink() {
        return this.imageLink;
    }

    public Integer getOtpMaxLength() {
        return this.otpMaxLength;
    }

    public OtpFormat getOtpFormat() {
        return this.otpFormat;
    }

    public String getAdditionalInformation() {
        return this.additionalInformation;
    }

    public void setImage(byte[] image) {
        this.image = image;
    }

    public void setData(List<String> data) {
        this.data = data;
    }

    public void setImageLink(String imageLink) {
        this.imageLink = imageLink;
    }

    public void setOtpMaxLength(Integer otpMaxLength) {
        this.otpMaxLength = otpMaxLength;
    }

    public void setOtpFormat(OtpFormat otpFormat) {
        this.otpFormat = otpFormat;
    }

    public void setAdditionalInformation(String additionalInformation) {
        this.additionalInformation = additionalInformation;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChallengeData)) {
            return false;
        }
        ChallengeData other = (ChallengeData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!Arrays.equals(this.getImage(), other.getImage())) {
            return false;
        }
        List<String> this$data = this.getData();
        List<String> other$data = other.getData();
        if (this$data == null ? other$data != null : !((Object)this$data).equals(other$data)) {
            return false;
        }
        String this$imageLink = this.getImageLink();
        String other$imageLink = other.getImageLink();
        if (this$imageLink == null ? other$imageLink != null : !this$imageLink.equals(other$imageLink)) {
            return false;
        }
        Integer this$otpMaxLength = this.getOtpMaxLength();
        Integer other$otpMaxLength = other.getOtpMaxLength();
        if (this$otpMaxLength == null ? other$otpMaxLength != null : !((Object)this$otpMaxLength).equals(other$otpMaxLength)) {
            return false;
        }
        OtpFormat this$otpFormat = this.getOtpFormat();
        OtpFormat other$otpFormat = other.getOtpFormat();
        if (this$otpFormat == null ? other$otpFormat != null : !((Object)((Object)this$otpFormat)).equals((Object)other$otpFormat)) {
            return false;
        }
        String this$additionalInformation = this.getAdditionalInformation();
        String other$additionalInformation = other.getAdditionalInformation();
        return !(this$additionalInformation == null ? other$additionalInformation != null : !this$additionalInformation.equals(other$additionalInformation));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ChallengeData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.getImage());
        List<String> $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        String $imageLink = this.getImageLink();
        result = result * 59 + ($imageLink == null ? 43 : $imageLink.hashCode());
        Integer $otpMaxLength = this.getOtpMaxLength();
        result = result * 59 + ($otpMaxLength == null ? 43 : ((Object)$otpMaxLength).hashCode());
        OtpFormat $otpFormat = this.getOtpFormat();
        result = result * 59 + ($otpFormat == null ? 43 : ((Object)((Object)$otpFormat)).hashCode());
        String $additionalInformation = this.getAdditionalInformation();
        result = result * 59 + ($additionalInformation == null ? 43 : $additionalInformation.hashCode());
        return result;
    }

    public String toString() {
        return "ChallengeData(image=" + Arrays.toString(this.getImage()) + ", data=" + this.getData() + ", imageLink=" + this.getImageLink() + ", otpMaxLength=" + this.getOtpMaxLength() + ", otpFormat=" + this.getOtpFormat() + ", additionalInformation=" + this.getAdditionalInformation() + ")";
    }

    @ConstructorProperties(value={"image", "data", "imageLink", "otpMaxLength", "otpFormat", "additionalInformation"})
    public ChallengeData(byte[] image, List<String> data, String imageLink, Integer otpMaxLength, OtpFormat otpFormat, String additionalInformation) {
        this.image = image;
        this.data = data;
        this.imageLink = imageLink;
        this.otpMaxLength = otpMaxLength;
        this.otpFormat = otpFormat;
        this.additionalInformation = additionalInformation;
    }

    public ChallengeData() {
    }
}

