/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.core.authorisation;

import de.adorsys.psd2.xs2a.core.authorisation.AuthorisationType;
import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel(description="Authorisation object", value="AuthorisationResponse")
public class Authorisation {
    @ApiModelProperty(value="ID of the Authorisation", required=true, example="6dc3d5b3-5023-7848-3853-f7200a64e80d")
    private String authorisationId;
    @ApiModelProperty(value="PSU identification data", required=true)
    private PsuIdData psuIdData;
    @ApiModelProperty(value="An identification of the created account consent", required=true, example="bf489af6-a2cb-4b75-b71d-d66d58b934d7")
    private String parentId;
    @ApiModelProperty(value="Authorisation type 'CONSENT', 'PIS_CREATION', 'PIS_CANCELLATION'.", required=true, example="AIS")
    private AuthorisationType authorisationType;
    @ApiModelProperty(value="The following code values are permitted 'received', 'psuIdentified', 'psuAuthenticated', 'scaMethodSelected', 'started', 'finalised' 'failed' 'exempted'.", required=true, example="STARTED")
    private ScaStatus scaStatus;
    @ApiModelProperty(value="An identification provided by the ASPSP for the later identification of the authentication method selection.")
    private String authenticationMethodId;
    @ApiModelProperty(value="Password")
    private String password;
    @ApiModelProperty(value="SCA authentication data")
    private String scaAuthenticationData;
    @ApiModelProperty(value="Chosen SCA approach")
    private ScaApproach chosenScaApproach;

    public Authorisation(String authorisationId, PsuIdData psuIdData, String parentId, AuthorisationType authorisationType, ScaStatus scaStatus) {
        this.authorisationId = authorisationId;
        this.psuIdData = psuIdData;
        this.parentId = parentId;
        this.authorisationType = authorisationType;
        this.scaStatus = scaStatus;
    }

    public String getAuthorisationId() {
        return this.authorisationId;
    }

    public PsuIdData getPsuIdData() {
        return this.psuIdData;
    }

    public String getParentId() {
        return this.parentId;
    }

    public AuthorisationType getAuthorisationType() {
        return this.authorisationType;
    }

    public ScaStatus getScaStatus() {
        return this.scaStatus;
    }

    public String getAuthenticationMethodId() {
        return this.authenticationMethodId;
    }

    public String getPassword() {
        return this.password;
    }

    public String getScaAuthenticationData() {
        return this.scaAuthenticationData;
    }

    public ScaApproach getChosenScaApproach() {
        return this.chosenScaApproach;
    }

    public void setAuthorisationId(String authorisationId) {
        this.authorisationId = authorisationId;
    }

    public void setPsuIdData(PsuIdData psuIdData) {
        this.psuIdData = psuIdData;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public void setAuthorisationType(AuthorisationType authorisationType) {
        this.authorisationType = authorisationType;
    }

    public void setScaStatus(ScaStatus scaStatus) {
        this.scaStatus = scaStatus;
    }

    public void setAuthenticationMethodId(String authenticationMethodId) {
        this.authenticationMethodId = authenticationMethodId;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setScaAuthenticationData(String scaAuthenticationData) {
        this.scaAuthenticationData = scaAuthenticationData;
    }

    public void setChosenScaApproach(ScaApproach chosenScaApproach) {
        this.chosenScaApproach = chosenScaApproach;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Authorisation)) {
            return false;
        }
        Authorisation other = (Authorisation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$authorisationId = this.getAuthorisationId();
        String other$authorisationId = other.getAuthorisationId();
        if (this$authorisationId == null ? other$authorisationId != null : !this$authorisationId.equals(other$authorisationId)) {
            return false;
        }
        PsuIdData this$psuIdData = this.getPsuIdData();
        PsuIdData other$psuIdData = other.getPsuIdData();
        if (this$psuIdData == null ? other$psuIdData != null : !((Object)this$psuIdData).equals(other$psuIdData)) {
            return false;
        }
        String this$parentId = this.getParentId();
        String other$parentId = other.getParentId();
        if (this$parentId == null ? other$parentId != null : !this$parentId.equals(other$parentId)) {
            return false;
        }
        AuthorisationType this$authorisationType = this.getAuthorisationType();
        AuthorisationType other$authorisationType = other.getAuthorisationType();
        if (this$authorisationType == null ? other$authorisationType != null : !((Object)((Object)this$authorisationType)).equals((Object)other$authorisationType)) {
            return false;
        }
        ScaStatus this$scaStatus = this.getScaStatus();
        ScaStatus other$scaStatus = other.getScaStatus();
        if (this$scaStatus == null ? other$scaStatus != null : !((Object)((Object)this$scaStatus)).equals((Object)other$scaStatus)) {
            return false;
        }
        String this$authenticationMethodId = this.getAuthenticationMethodId();
        String other$authenticationMethodId = other.getAuthenticationMethodId();
        if (this$authenticationMethodId == null ? other$authenticationMethodId != null : !this$authenticationMethodId.equals(other$authenticationMethodId)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$scaAuthenticationData = this.getScaAuthenticationData();
        String other$scaAuthenticationData = other.getScaAuthenticationData();
        if (this$scaAuthenticationData == null ? other$scaAuthenticationData != null : !this$scaAuthenticationData.equals(other$scaAuthenticationData)) {
            return false;
        }
        ScaApproach this$chosenScaApproach = this.getChosenScaApproach();
        ScaApproach other$chosenScaApproach = other.getChosenScaApproach();
        return !(this$chosenScaApproach == null ? other$chosenScaApproach != null : !((Object)((Object)this$chosenScaApproach)).equals((Object)other$chosenScaApproach));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Authorisation;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $authorisationId = this.getAuthorisationId();
        result = result * 59 + ($authorisationId == null ? 43 : $authorisationId.hashCode());
        PsuIdData $psuIdData = this.getPsuIdData();
        result = result * 59 + ($psuIdData == null ? 43 : ((Object)$psuIdData).hashCode());
        String $parentId = this.getParentId();
        result = result * 59 + ($parentId == null ? 43 : $parentId.hashCode());
        AuthorisationType $authorisationType = this.getAuthorisationType();
        result = result * 59 + ($authorisationType == null ? 43 : ((Object)((Object)$authorisationType)).hashCode());
        ScaStatus $scaStatus = this.getScaStatus();
        result = result * 59 + ($scaStatus == null ? 43 : ((Object)((Object)$scaStatus)).hashCode());
        String $authenticationMethodId = this.getAuthenticationMethodId();
        result = result * 59 + ($authenticationMethodId == null ? 43 : $authenticationMethodId.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $scaAuthenticationData = this.getScaAuthenticationData();
        result = result * 59 + ($scaAuthenticationData == null ? 43 : $scaAuthenticationData.hashCode());
        ScaApproach $chosenScaApproach = this.getChosenScaApproach();
        result = result * 59 + ($chosenScaApproach == null ? 43 : ((Object)((Object)$chosenScaApproach)).hashCode());
        return result;
    }

    public String toString() {
        return "Authorisation(authorisationId=" + this.getAuthorisationId() + ", psuIdData=" + this.getPsuIdData() + ", parentId=" + this.getParentId() + ", authorisationType=" + this.getAuthorisationType() + ", scaStatus=" + this.getScaStatus() + ", authenticationMethodId=" + this.getAuthenticationMethodId() + ", password=" + this.getPassword() + ", scaAuthenticationData=" + this.getScaAuthenticationData() + ", chosenScaApproach=" + this.getChosenScaApproach() + ")";
    }

    public Authorisation() {
    }
}

