/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.core.psu;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.adorsys.psd2.xs2a.core.psu.AdditionalPsuIdData;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public final class PsuIdData {
    @Nullable
    private final String psuId;
    @Nullable
    private final String psuIdType;
    @Nullable
    private final String psuCorporateId;
    @Nullable
    private final String psuCorporateIdType;
    @Nullable
    private final String psuIpAddress;
    @Nullable
    private final AdditionalPsuIdData additionalPsuIdData;

    public PsuIdData() {
        this(null, null, null, null, null);
    }

    public PsuIdData(String psuId, String psuIdType, String psuCorporateId, String psuCorporateIdType, String psuIpAddress) {
        this(psuId, psuIdType, psuCorporateId, psuCorporateIdType, psuIpAddress, null);
    }

    public PsuIdData(String psuId, String psuIdType, String psuCorporateId, String psuCorporateIdType, String psuIpAddress, AdditionalPsuIdData additionalPsuIdData) {
        this.psuId = psuId;
        this.psuIdType = psuIdType;
        this.psuCorporateId = psuCorporateId;
        this.psuCorporateIdType = psuCorporateIdType;
        this.psuIpAddress = psuIpAddress;
        this.additionalPsuIdData = additionalPsuIdData;
    }

    public boolean contentEquals(PsuIdData otherPsuIdData) {
        if (Objects.isNull(otherPsuIdData)) {
            return false;
        }
        return StringUtils.equals((CharSequence)this.getPsuId(), (CharSequence)otherPsuIdData.getPsuId()) && StringUtils.equals((CharSequence)this.getPsuCorporateId(), (CharSequence)otherPsuIdData.getPsuCorporateId()) && StringUtils.equals((CharSequence)this.getPsuCorporateIdType(), (CharSequence)otherPsuIdData.getPsuCorporateIdType()) && StringUtils.equals((CharSequence)this.getPsuIdType(), (CharSequence)otherPsuIdData.getPsuIdType());
    }

    @JsonIgnore
    public boolean isEmpty() {
        return StringUtils.isBlank((CharSequence)this.getPsuId());
    }

    @JsonIgnore
    public boolean isNotEmpty() {
        return !this.isEmpty();
    }

    @Nullable
    public String getPsuId() {
        return this.psuId;
    }

    @Nullable
    public String getPsuIdType() {
        return this.psuIdType;
    }

    @Nullable
    public String getPsuCorporateId() {
        return this.psuCorporateId;
    }

    @Nullable
    public String getPsuCorporateIdType() {
        return this.psuCorporateIdType;
    }

    @Nullable
    public String getPsuIpAddress() {
        return this.psuIpAddress;
    }

    @Nullable
    public AdditionalPsuIdData getAdditionalPsuIdData() {
        return this.additionalPsuIdData;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PsuIdData)) {
            return false;
        }
        PsuIdData other = (PsuIdData)o;
        String this$psuId = this.getPsuId();
        String other$psuId = other.getPsuId();
        if (this$psuId == null ? other$psuId != null : !this$psuId.equals(other$psuId)) {
            return false;
        }
        String this$psuIdType = this.getPsuIdType();
        String other$psuIdType = other.getPsuIdType();
        if (this$psuIdType == null ? other$psuIdType != null : !this$psuIdType.equals(other$psuIdType)) {
            return false;
        }
        String this$psuCorporateId = this.getPsuCorporateId();
        String other$psuCorporateId = other.getPsuCorporateId();
        if (this$psuCorporateId == null ? other$psuCorporateId != null : !this$psuCorporateId.equals(other$psuCorporateId)) {
            return false;
        }
        String this$psuCorporateIdType = this.getPsuCorporateIdType();
        String other$psuCorporateIdType = other.getPsuCorporateIdType();
        if (this$psuCorporateIdType == null ? other$psuCorporateIdType != null : !this$psuCorporateIdType.equals(other$psuCorporateIdType)) {
            return false;
        }
        String this$psuIpAddress = this.getPsuIpAddress();
        String other$psuIpAddress = other.getPsuIpAddress();
        if (this$psuIpAddress == null ? other$psuIpAddress != null : !this$psuIpAddress.equals(other$psuIpAddress)) {
            return false;
        }
        AdditionalPsuIdData this$additionalPsuIdData = this.getAdditionalPsuIdData();
        AdditionalPsuIdData other$additionalPsuIdData = other.getAdditionalPsuIdData();
        return !(this$additionalPsuIdData == null ? other$additionalPsuIdData != null : !((Object)this$additionalPsuIdData).equals(other$additionalPsuIdData));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $psuId = this.getPsuId();
        result = result * 59 + ($psuId == null ? 43 : $psuId.hashCode());
        String $psuIdType = this.getPsuIdType();
        result = result * 59 + ($psuIdType == null ? 43 : $psuIdType.hashCode());
        String $psuCorporateId = this.getPsuCorporateId();
        result = result * 59 + ($psuCorporateId == null ? 43 : $psuCorporateId.hashCode());
        String $psuCorporateIdType = this.getPsuCorporateIdType();
        result = result * 59 + ($psuCorporateIdType == null ? 43 : $psuCorporateIdType.hashCode());
        String $psuIpAddress = this.getPsuIpAddress();
        result = result * 59 + ($psuIpAddress == null ? 43 : $psuIpAddress.hashCode());
        AdditionalPsuIdData $additionalPsuIdData = this.getAdditionalPsuIdData();
        result = result * 59 + ($additionalPsuIdData == null ? 43 : ((Object)$additionalPsuIdData).hashCode());
        return result;
    }

    public String toString() {
        return "PsuIdData(psuId=" + this.getPsuId() + ", psuIdType=" + this.getPsuIdType() + ", psuCorporateId=" + this.getPsuCorporateId() + ", psuCorporateIdType=" + this.getPsuCorporateIdType() + ", psuIpAddress=" + this.getPsuIpAddress() + ", additionalPsuIdData=" + this.getAdditionalPsuIdData() + ")";
    }
}

