/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.core.error;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public enum MessageErrorCode {
    SERVICE_NOT_SUPPORTED(406),
    ROLE_INVALID(401),
    CERTIFICATE_INVALID(401),
    CERTIFICATE_INVALID_TPP(401){

        @Override
        public String getName() {
            return MessageErrorCode.CERTIFICATE_INVALID_NAME;
        }
    }
    ,
    CERTIFICATE_INVALID_NO_ACCESS(401){

        @Override
        public String getName() {
            return MessageErrorCode.CERTIFICATE_INVALID_NAME;
        }
    }
    ,
    CERTIFICATE_EXPIRED(401),
    CERTIFICATE_BLOCKED(401),
    CERTIFICATE_REVOKED(401),
    CERTIFICATE_MISSING(401),
    SIGNATURE_INVALID(401),
    SIGNATURE_MISSING(401),
    FORMAT_ERROR(400),
    FORMAT_ERROR_NO_PSU(400){

        @Override
        public String getName() {
            return MessageErrorCode.FORMAT_ERROR_NAME;
        }
    }
    ,
    FORMAT_ERROR_NO_PSU_ID(400){

        @Override
        public String getName() {
            return MessageErrorCode.FORMAT_ERROR_NAME;
        }
    }
    ,
    FORMAT_ERROR_PSU_ID_BLANK(400){

        @Override
        public String getName() {
            return MessageErrorCode.FORMAT_ERROR_NAME;
        }
    }
    ,
    FORMAT_ERROR_MULTIPLE_ACCOUNT_REFERENCES(400){

        @Override
        public String getName() {
            return MessageErrorCode.FORMAT_ERROR_NAME;
        }
    }
    ,
    FORMAT_ERROR_ATTRIBUTE_NOT_SUPPORTED(400){

        @Override
        public String getName() {
            return MessageErrorCode.FORMAT_ERROR_NAME;
        }
    }
    ,
    FORMAT_ERROR_MULTIPLE_DELTA_REPORT(400){

        @Override
        public String getName() {
            return MessageErrorCode.FORMAT_ERROR_NAME;
        }
    }
    ,
    FORMAT_ERROR_ABSENT_HEADER(400){

        @Override
        public String getName() {
            return MessageErrorCode.FORMAT_ERROR_NAME;
        }
    }
    ,
    FORMAT_ERROR_NULL_HEADER(400){

        @Override
        public String getName() {
            return MessageErrorCode.FORMAT_ERROR_NAME;
        }
    }
    ,
    FORMAT_ERROR_BLANK_HEADER(400){

        @Override
        public String getName() {
            return MessageErrorCode.FORMAT_ERROR_NAME;
        }
    }
    ,
    FORMAT_ERROR_WRONG_IP_ADDRESS(400){

        @Override
        public String getName() {
            return MessageErrorCode.FORMAT_ERROR_NAME;
        }
    }
    ,
    FORMAT_ERROR_INVALID_DOMAIN(400){

        @Override
        public String getName() {
            return MessageErrorCode.FORMAT_ERROR_NAME;
        }
    }
    ,
    FORMAT_ERROR_WRONG_HEADER(400){

        @Override
        public String getName() {
            return MessageErrorCode.FORMAT_ERROR_NAME;
        }
    }
    ,
    FORMAT_ERROR_PAYMENT_NOT_FOUND(400){

        @Override
        public String getName() {
            return MessageErrorCode.FORMAT_ERROR_NAME;
        }
    }
    ,
    FORMAT_ERROR_INVALID_DAY_OF_EXECUTION(400){

        @Override
        public String getName() {
            return MessageErrorCode.FORMAT_ERROR_NAME;
        }
    }
    ,
    FORMAT_ERROR_ABSENT_PARAMETER(400){

        @Override
        public String getName() {
            return MessageErrorCode.FORMAT_ERROR_NAME;
        }
    }
    ,
    FORMAT_ERROR_INVALID_PARAMETER_VALUE(400){

        @Override
        public String getName() {
            return MessageErrorCode.FORMAT_ERROR_NAME;
        }
    }
    ,
    FORMAT_ERROR_BLANK_PARAMETER(400){

        @Override
        public String getName() {
            return MessageErrorCode.FORMAT_ERROR_NAME;
        }
    }
    ,
    FORMAT_ERROR_INVALID_FIELD(400){

        @Override
        public String getName() {
            return MessageErrorCode.FORMAT_ERROR_NAME;
        }
    }
    ,
    FORMAT_ERROR_EXTRA_FIELD(400){

        @Override
        public String getName() {
            return MessageErrorCode.FORMAT_ERROR_NAME;
        }
    }
    ,
    FORMAT_ERROR_EMPTY_FIELD(400){

        @Override
        public String getName() {
            return MessageErrorCode.FORMAT_ERROR_NAME;
        }
    }
    ,
    FORMAT_ERROR_OVERSIZE_FIELD(400){

        @Override
        public String getName() {
            return MessageErrorCode.FORMAT_ERROR_NAME;
        }
    }
    ,
    FORMAT_ERROR_DESERIALIZATION_FAIL(400){

        @Override
        public String getName() {
            return MessageErrorCode.FORMAT_ERROR_NAME;
        }
    }
    ,
    FORMAT_ERROR_NULL_VALUE(400){

        @Override
        public String getName() {
            return MessageErrorCode.FORMAT_ERROR_NAME;
        }
    }
    ,
    FORMAT_ERROR_WRONG_FORMAT_VALUE(400){

        @Override
        public String getName() {
            return MessageErrorCode.FORMAT_ERROR_NAME;
        }
    }
    ,
    FORMAT_ERROR_WRONG_FORMAT_DATE_FIELD(400){

        @Override
        public String getName() {
            return MessageErrorCode.FORMAT_ERROR_NAME;
        }
    }
    ,
    FORMAT_ERROR_CONSENT_INCORRECT(400){

        @Override
        public String getName() {
            return MessageErrorCode.FORMAT_ERROR_NAME;
        }
    }
    ,
    FORMAT_ERROR_DATE_IN_THE_PAST(400){

        @Override
        public String getName() {
            return MessageErrorCode.FORMAT_ERROR_NAME;
        }
    }
    ,
    FORMAT_ERROR_INVALID_FREQUENCY(400){

        @Override
        public String getName() {
            return MessageErrorCode.FORMAT_ERROR_NAME;
        }
    }
    ,
    FORMAT_ERROR_VALUE_REQUIRED(400){

        @Override
        public String getName() {
            return MessageErrorCode.FORMAT_ERROR_NAME;
        }
    }
    ,
    FORMAT_ERROR_ADDRESS_COUNTRY_INCORRECT(400){

        @Override
        public String getName() {
            return MessageErrorCode.FORMAT_ERROR_NAME;
        }
    }
    ,
    FORMAT_ERROR_BOOLEAN_VALUE(400){

        @Override
        public String getName() {
            return MessageErrorCode.FORMAT_ERROR_NAME;
        }
    }
    ,
    FORMAT_ERROR_OVERSIZE_HEADER(400){

        @Override
        public String getName() {
            return MessageErrorCode.FORMAT_ERROR_NAME;
        }
    }
    ,
    FORMAT_ERROR_PATH_PARAMETER_INVALID(400){

        @Override
        public String getName() {
            return MessageErrorCode.FORMAT_ERROR_NAME;
        }
    }
    ,
    FORMAT_ERROR_UNKNOWN_ACCOUNT(400){

        @Override
        public String getName() {
            return MessageErrorCode.FORMAT_ERROR_NAME;
        }
    }
    ,
    FORMAT_ERROR_SCA_METHODS(400){

        @Override
        public String getName() {
            return MessageErrorCode.FORMAT_ERROR_NAME;
        }
    }
    ,
    FORMAT_ERROR_PAYMENT_NOT_EXECUTED(400){

        @Override
        public String getName() {
            return MessageErrorCode.FORMAT_ERROR_NAME;
        }
    }
    ,
    FORMAT_ERROR_CANCELLATION(400){

        @Override
        public String getName() {
            return MessageErrorCode.FORMAT_ERROR_NAME;
        }
    }
    ,
    FORMAT_ERROR_SCA_STATUS(400){

        @Override
        public String getName() {
            return MessageErrorCode.FORMAT_ERROR_NAME;
        }
    }
    ,
    FORMAT_ERROR_RESPONSE_TYPE(400){

        @Override
        public String getName() {
            return MessageErrorCode.FORMAT_ERROR_NAME;
        }
    }
    ,
    FORMAT_ERROR_BULK(400){

        @Override
        public String getName() {
            return MessageErrorCode.FORMAT_ERROR_NAME;
        }
    }
    ,
    RESOURCE_BLOCKED(400),
    PSU_CREDENTIALS_INVALID(401),
    PSU_CREDENTIALS_INVALID_FOR_CANCELLATION(401){

        @Override
        public String getName() {
            return "PSU_CREDENTIALS_INVALID";
        }
    }
    ,
    CORPORATE_ID_INVALID(401),
    CONSENT_INVALID(401),
    CONSENT_INVALID_REVOKED(401){

        @Override
        public String getName() {
            return "CONSENT_INVALID";
        }
    }
    ,
    CONSENT_EXPIRED(401),
    TOKEN_UNKNOWN(401),
    TOKEN_INVALID(401),
    TOKEN_EXPIRED(401),
    TIMESTAMP_INVALID(400),
    PERIOD_INVALID(400),
    PERIOD_INVALID_WRONG_ORDER(400){

        @Override
        public String getName() {
            return "PERIOD_INVALID";
        }
    }
    ,
    SCA_METHOD_UNKNOWN(400),
    SCA_METHOD_UNKNOWN_PROCESS_MISMATCH(400){

        @Override
        public String getName() {
            return "SCA_METHOD_UNKNOWN";
        }
    }
    ,
    TRANSACTION_ID_INVALID(400),
    PRODUCT_INVALID(403),
    PRODUCT_INVALID_FOR_PAYMENT(403){

        @Override
        public String getName() {
            return "PRODUCT_INVALID";
        }
    }
    ,
    PRODUCT_UNKNOWN(404),
    PRODUCT_UNKNOWN_WRONG_PAYMENT_PRODUCT(404){

        @Override
        public String getName() {
            return "PRODUCT_UNKNOWN";
        }
    }
    ,
    PAYMENT_FAILED(400),
    PAYMENT_FAILED_TYPE_UNKNOWN(400){

        @Override
        public String getName() {
            return "PAYMENT_FAILED";
        }
    }
    ,
    PAYMENT_FAILED_INCORRECT_ID(400){

        @Override
        public String getName() {
            return "PAYMENT_FAILED";
        }
    }
    ,
    REQUIRED_KID_MISSING(401),
    EXECUTION_DATE_INVALID(400),
    EXECUTION_DATE_INVALID_IN_THE_PAST(400){

        @Override
        public String getName() {
            return "EXECUTION_DATE_INVALID";
        }
    }
    ,
    CARD_INVALID(400),
    NO_PIIS_ACTIVATION(400),
    REFERENCE_MIX_INVALID(400),
    REFERENCE_STATUS_INVALID(409),
    SESSIONS_NOT_SUPPORTED(400),
    ACCESS_EXCEEDED(429),
    REQUESTED_FORMATS_INVALID(406),
    SERVICE_INVALID_400(400){

        @Override
        public String getName() {
            return MessageErrorCode.SERVICE_INVALID_NAME;
        }
    }
    ,
    SERVICE_INVALID_400_FOR_PAYMENT(400){

        @Override
        public String getName() {
            return MessageErrorCode.SERVICE_INVALID_NAME;
        }
    }
    ,
    SERVICE_INVALID_400_FOR_GLOBAL_CONSENT(400){

        @Override
        public String getName() {
            return MessageErrorCode.SERVICE_INVALID_NAME;
        }
    }
    ,
    SERVICE_INVALID_405(405){

        @Override
        public String getName() {
            return MessageErrorCode.SERVICE_INVALID_NAME;
        }
    }
    ,
    SERVICE_INVALID_405_METHOD_NOT_SUPPORTED(405){

        @Override
        public String getName() {
            return MessageErrorCode.SERVICE_INVALID_NAME;
        }
    }
    ,
    SERVICE_BLOCKED(403),
    CONSENT_UNKNOWN_403(403){

        @Override
        public String getName() {
            return MessageErrorCode.CONSENT_UNKNOWN_NAME;
        }
    }
    ,
    CONSENT_UNKNOWN_403_INCORRECT_CERTIFICATE(403){

        @Override
        public String getName() {
            return MessageErrorCode.CONSENT_UNKNOWN_NAME;
        }
    }
    ,
    CONSENT_UNKNOWN_400(400){

        @Override
        public String getName() {
            return MessageErrorCode.CONSENT_UNKNOWN_NAME;
        }
    }
    ,
    CONSENT_UNKNOWN_400_INCORRECT_CERTIFICATE(400){

        @Override
        public String getName() {
            return MessageErrorCode.CONSENT_UNKNOWN_NAME;
        }
    }
    ,
    CONSENT_UNKNOWN_400_UNKNOWN_ACCESS_TYPE(400){

        @Override
        public String getName() {
            return MessageErrorCode.CONSENT_UNKNOWN_NAME;
        }
    }
    ,
    CONSENT_UNKNOWN_400_NULL_ACCESS_TYPE(400){

        @Override
        public String getName() {
            return MessageErrorCode.CONSENT_UNKNOWN_NAME;
        }
    }
    ,
    RESOURCE_UNKNOWN_404(404){

        @Override
        public String getName() {
            return MessageErrorCode.RESOURCE_UNKNOWN_NAME;
        }
    }
    ,
    RESOURCE_UNKNOWN_404_NO_PAYMENT(404){

        @Override
        public String getName() {
            return MessageErrorCode.RESOURCE_UNKNOWN_NAME;
        }
    }
    ,
    RESOURCE_UNKNOWN_404_NO_AUTHORISATION(404){

        @Override
        public String getName() {
            return MessageErrorCode.RESOURCE_UNKNOWN_NAME;
        }
    }
    ,
    RESOURCE_UNKNOWN_404_NO_CANC_AUTHORISATION(404){

        @Override
        public String getName() {
            return MessageErrorCode.RESOURCE_UNKNOWN_NAME;
        }
    }
    ,
    RESOURCE_UNKNOWN_403(403){

        @Override
        public String getName() {
            return MessageErrorCode.RESOURCE_UNKNOWN_NAME;
        }
    }
    ,
    RESOURCE_UNKNOWN_400(400){

        @Override
        public String getName() {
            return MessageErrorCode.RESOURCE_UNKNOWN_NAME;
        }
    }
    ,
    RESOURCE_EXPIRED_403(403){

        @Override
        public String getName() {
            return MessageErrorCode.RESOURCE_EXPIRED_NAME;
        }
    }
    ,
    RESOURCE_EXPIRED_400(400){

        @Override
        public String getName() {
            return MessageErrorCode.RESOURCE_EXPIRED_NAME;
        }
    }
    ,
    PARAMETER_NOT_SUPPORTED(400),
    PARAMETER_NOT_SUPPORTED_BOOKING_STATUS(400){

        @Override
        public String getName() {
            return MessageErrorCode.PARAMETER_NOT_SUPPORTED_STRING;
        }
    }
    ,
    PARAMETER_NOT_SUPPORTED_ENTRY_REFERENCE_FROM(400){

        @Override
        public String getName() {
            return MessageErrorCode.PARAMETER_NOT_SUPPORTED_STRING;
        }
    }
    ,
    PARAMETER_NOT_SUPPORTED_DELTA_LIST(400){

        @Override
        public String getName() {
            return MessageErrorCode.PARAMETER_NOT_SUPPORTED_STRING;
        }
    }
    ,
    PARAMETER_NOT_SUPPORTED_WRONG_PAYMENT_TYPE(400){

        @Override
        public String getName() {
            return MessageErrorCode.PARAMETER_NOT_SUPPORTED_STRING;
        }
    }
    ,
    BEARER_TOKEN_EMPTY(400),
    INTERNAL_SERVER_ERROR(500),
    UNAUTHORIZED(401),
    UNAUTHORIZED_NO_PSU(401){

        @Override
        public String getName() {
            return MessageErrorCode.UNAUTHORIZED_STRING;
        }
    }
    ,
    UNAUTHORIZED_CANCELLATION(401){

        @Override
        public String getName() {
            return MessageErrorCode.UNAUTHORIZED_STRING;
        }
    }
    ,
    PARAMETER_NOT_CONSISTENT(400),
    CONTENT_TYPE_NOT_SUPPORTED(406),
    UNSUPPORTED_MEDIA_TYPE(415),
    CANCELLATION_INVALID(405),
    SERVICE_UNAVAILABLE(503),
    STATUS_INVALID(409),
    FUNDS_CONFIRMATION_FAILED(400);

    private static final String CERTIFICATE_INVALID_NAME = "CERTIFICATE_INVALID";
    private static final String FORMAT_ERROR_NAME = "FORMAT_ERROR";
    private static final String SERVICE_INVALID_NAME = "SERVICE_INVALID";
    private static final String CONSENT_UNKNOWN_NAME = "CONSENT_UNKNOWN";
    private static final String RESOURCE_UNKNOWN_NAME = "RESOURCE_UNKNOWN";
    private static final String RESOURCE_EXPIRED_NAME = "RESOURCE_EXPIRED";
    private static final String PARAMETER_NOT_SUPPORTED_STRING = "PARAMETER_NOT_SUPPORTED";
    private static final String UNAUTHORIZED_STRING = "UNAUTHORIZED";
    private static Map<String, MessageErrorCode> container;
    @ApiModelProperty(value="code", example="400")
    private int code;

    @JsonCreator
    private MessageErrorCode(int code) {
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    @JsonValue
    public String getName() {
        return this.name();
    }

    @JsonIgnore
    public static Optional<MessageErrorCode> getByName(String name) {
        return Optional.ofNullable(container.get(name));
    }

    static {
        container = new HashMap<String, MessageErrorCode>();
        Arrays.stream(MessageErrorCode.values()).forEach(errorCode -> container.put(errorCode.getName(), (MessageErrorCode)((Object)errorCode)));
    }
}

