/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.core.tpp;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.adorsys.psd2.xs2a.core.tpp.TppRedirectUri;
import de.adorsys.psd2.xs2a.core.tpp.TppRole;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public class TppInfo {
    @ApiModelProperty(value="Authorization number", required=true, example="12345987")
    private String authorisationNumber;
    @ApiModelProperty(value="Tpp name", required=true, example="Tpp company")
    private String tppName;
    @ApiModelProperty(value="Tpp role", required=true)
    private List<TppRole> tppRoles;
    @ApiModelProperty(value="National competent authority id", required=true, example="authority id")
    private String authorityId;
    @ApiModelProperty(value="National competent authority name", required=true, example="authority name")
    private String authorityName;
    @ApiModelProperty(value="Country", required=true, example="Germany")
    private String country;
    @ApiModelProperty(value="Organisation", required=true, example="Organisation")
    private String organisation;
    @ApiModelProperty(value="Organisation unit", required=true, example="Organisation unit")
    private String organisationUnit;
    @ApiModelProperty(value="City", required=true, example="Nuremberg")
    private String city;
    @ApiModelProperty(value="State", required=true, example="Bayern")
    private String state;
    @ApiModelProperty(value="TPP redirect URIs")
    @Nullable
    private TppRedirectUri tppRedirectUri;
    @ApiModelProperty(value="Issuer CN", required=true, example="Authority CA Domain Name")
    private String issuerCN;

    @JsonIgnore
    public boolean isNotValid() {
        return !this.isValid();
    }

    @JsonIgnore
    public boolean isValid() {
        return StringUtils.isNotBlank((CharSequence)this.authorisationNumber) && StringUtils.isNotBlank((CharSequence)this.authorityId);
    }

    public String getAuthorisationNumber() {
        return this.authorisationNumber;
    }

    public String getTppName() {
        return this.tppName;
    }

    public List<TppRole> getTppRoles() {
        return this.tppRoles;
    }

    public String getAuthorityId() {
        return this.authorityId;
    }

    public String getAuthorityName() {
        return this.authorityName;
    }

    public String getCountry() {
        return this.country;
    }

    public String getOrganisation() {
        return this.organisation;
    }

    public String getOrganisationUnit() {
        return this.organisationUnit;
    }

    public String getCity() {
        return this.city;
    }

    public String getState() {
        return this.state;
    }

    @Nullable
    public TppRedirectUri getTppRedirectUri() {
        return this.tppRedirectUri;
    }

    public String getIssuerCN() {
        return this.issuerCN;
    }

    public void setAuthorisationNumber(String authorisationNumber) {
        this.authorisationNumber = authorisationNumber;
    }

    public void setTppName(String tppName) {
        this.tppName = tppName;
    }

    public void setTppRoles(List<TppRole> tppRoles) {
        this.tppRoles = tppRoles;
    }

    public void setAuthorityId(String authorityId) {
        this.authorityId = authorityId;
    }

    public void setAuthorityName(String authorityName) {
        this.authorityName = authorityName;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public void setOrganisation(String organisation) {
        this.organisation = organisation;
    }

    public void setOrganisationUnit(String organisationUnit) {
        this.organisationUnit = organisationUnit;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public void setState(String state) {
        this.state = state;
    }

    public void setTppRedirectUri(@Nullable TppRedirectUri tppRedirectUri) {
        this.tppRedirectUri = tppRedirectUri;
    }

    public void setIssuerCN(String issuerCN) {
        this.issuerCN = issuerCN;
    }

    public String toString() {
        return "TppInfo(authorisationNumber=" + this.getAuthorisationNumber() + ", tppName=" + this.getTppName() + ", tppRoles=" + this.getTppRoles() + ", authorityId=" + this.getAuthorityId() + ", authorityName=" + this.getAuthorityName() + ", country=" + this.getCountry() + ", organisation=" + this.getOrganisation() + ", organisationUnit=" + this.getOrganisationUnit() + ", city=" + this.getCity() + ", state=" + this.getState() + ", tppRedirectUri=" + this.getTppRedirectUri() + ", issuerCN=" + this.getIssuerCN() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TppInfo)) {
            return false;
        }
        TppInfo other = (TppInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$authorisationNumber = this.getAuthorisationNumber();
        String other$authorisationNumber = other.getAuthorisationNumber();
        if (this$authorisationNumber == null ? other$authorisationNumber != null : !this$authorisationNumber.equals(other$authorisationNumber)) {
            return false;
        }
        String this$authorityId = this.getAuthorityId();
        String other$authorityId = other.getAuthorityId();
        return !(this$authorityId == null ? other$authorityId != null : !this$authorityId.equals(other$authorityId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TppInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $authorisationNumber = this.getAuthorisationNumber();
        result = result * 59 + ($authorisationNumber == null ? 43 : $authorisationNumber.hashCode());
        String $authorityId = this.getAuthorityId();
        result = result * 59 + ($authorityId == null ? 43 : $authorityId.hashCode());
        return result;
    }
}

