/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.core.pis;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public enum PisExecutionRule {
    FOLLOWING("following"),
    PRECEEDING("preceeding");

    private String value;
    private static final Map<String, PisExecutionRule> container;

    @JsonCreator
    private PisExecutionRule(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public static Optional<PisExecutionRule> getByValue(String name) {
        return Optional.ofNullable(container.get(name));
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    static {
        container = new HashMap<String, PisExecutionRule>();
        for (PisExecutionRule rule : PisExecutionRule.values()) {
            container.put(rule.getValue(), rule);
        }
    }
}

