/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.core.ais;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public enum AccountAccessType {
    ALL_ACCOUNTS("allAccounts"),
    ALL_ACCOUNTS_WITH_BALANCES("allAccountsWithBalances");

    private static Map<String, AccountAccessType> container;
    private String description;

    private AccountAccessType(String description) {
        this.description = description;
    }

    @JsonValue
    public String getDescription() {
        return this.description;
    }

    @JsonCreator
    public static Optional<AccountAccessType> getByDescription(String description) {
        return Optional.ofNullable(container.get(description));
    }

    static {
        container = new HashMap<String, AccountAccessType>();
        Arrays.stream(AccountAccessType.values()).forEach(aat -> container.put(aat.getDescription(), (AccountAccessType)((Object)aat)));
    }
}

