/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.core.profile;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import de.adorsys.psd2.xs2a.core.profile.AccountReference;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;

public enum AccountReferenceType {
    IBAN(1, "iban", AccountReference::getIban, AccountReference::setIban),
    BBAN(2, "bban", AccountReference::getBban, AccountReference::setBban),
    PAN(3, "pan", AccountReference::getPan, AccountReference::setPan),
    MSISDN(4, "msisdn", AccountReference::getMsisdn, AccountReference::setMsisdn),
    MASKED_PAN(5, "maskedPan", AccountReference::getMaskedPan, AccountReference::setMaskedPan);

    private String value;
    private int order;
    private Function<AccountReference, String> getter;
    private BiConsumer<AccountReference, String> setter;

    @JsonCreator
    private AccountReferenceType(int order, String value, Function<AccountReference, String> getter, BiConsumer<AccountReference, String> setter) {
        this.order = order;
        this.value = value;
        this.getter = getter;
        this.setter = setter;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public int getOrder() {
        return this.order;
    }

    public static Optional<AccountReferenceType> getByValue(String name) {
        return Arrays.stream(AccountReferenceType.values()).filter(type -> type.getValue().equals(name)).findFirst();
    }

    public String getFieldValue(AccountReference accountReference) {
        return this.getter.apply(accountReference);
    }

    public void setFieldValue(AccountReference accountReference, String fieldValue) {
        this.setter.accept(accountReference, fieldValue);
    }
}

