/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.core.profile;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.adorsys.psd2.xs2a.core.profile.AccountReferenceSelector;
import de.adorsys.psd2.xs2a.core.profile.AccountReferenceType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.beans.ConstructorProperties;
import java.util.Comparator;
import java.util.Currency;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

@ApiModel(description="Account Reference", value="AccountReference")
public class AccountReference {
    @ApiModelProperty(example="123-DEDE89370400440532013000-EUR")
    private String aspspAccountId;
    @ApiModelProperty(value="RESOURCE-ID: This identification is denoting the addressed account.")
    private String resourceId;
    @ApiModelProperty(value="IBAN: This data element can be used in the body of the CreateConsentReq Request Message for retrieving account access consent from this payment account", example="DE89370400440532013000")
    private String iban;
    @ApiModelProperty(value="BBAN: This data elements is used for payment accounts which have no IBAN", example="89370400440532013000")
    private String bban;
    @ApiModelProperty(value="PAN: Primary Account Number (PAN) of a card, can be tokenized by the ASPSP due to PCI DSS requirements.", example="2356 5746 3217 1234")
    private String pan;
    @ApiModelProperty(value="MASKEDPAN: Primary Account Number (PAN) of a card in a masked form.", example="2356xxxxxx1234")
    private String maskedPan;
    @ApiModelProperty(value="MSISDN: An alias to access a payment account via a registered mobile phone number. This alias might be needed e.g. in the payment initiation service, cp. Section 5.3.1. The support of this alias must be explicitly documented by the ASPSP for the corresponding API calls.", example="+49(0)911 360698-0")
    private String msisdn;
    @ApiModelProperty(value="Codes following ISO 4217", example="EUR")
    private Currency currency;

    public AccountReference(AccountReferenceType accountReferenceType, String accountReferenceValue, Currency currency) {
        this(accountReferenceType, accountReferenceValue, currency, null, null);
    }

    public AccountReference(AccountReferenceType accountReferenceType, String accountReferenceValue, Currency currency, String resourceId, String aspspAccountId) {
        if (accountReferenceType != null) {
            accountReferenceType.setFieldValue(this, accountReferenceValue);
        }
        this.currency = currency;
        this.resourceId = resourceId;
        this.aspspAccountId = aspspAccountId;
    }

    @JsonIgnore
    public AccountReferenceSelector getUsedAccountReferenceSelector() {
        return Stream.of(AccountReferenceType.values()).sorted(Comparator.comparingInt(AccountReferenceType::getOrder)).filter(type -> StringUtils.isNotBlank((CharSequence)type.getFieldValue(this))).findFirst().map(type -> new AccountReferenceSelector((AccountReferenceType)((Object)type), type.getFieldValue(this))).orElseThrow(() -> new IllegalArgumentException("At least one account reference property must be set!"));
    }

    @JsonIgnore
    public Set<AccountReferenceType> getUsedAccountReferenceFields() {
        return Stream.of(AccountReferenceType.values()).filter(type -> StringUtils.isNotBlank((CharSequence)type.getFieldValue(this))).collect(Collectors.toSet());
    }

    public String getAspspAccountId() {
        return this.aspspAccountId;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public String getIban() {
        return this.iban;
    }

    public String getBban() {
        return this.bban;
    }

    public String getPan() {
        return this.pan;
    }

    public String getMaskedPan() {
        return this.maskedPan;
    }

    public String getMsisdn() {
        return this.msisdn;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public void setAspspAccountId(String aspspAccountId) {
        this.aspspAccountId = aspspAccountId;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public void setIban(String iban) {
        this.iban = iban;
    }

    public void setBban(String bban) {
        this.bban = bban;
    }

    public void setPan(String pan) {
        this.pan = pan;
    }

    public void setMaskedPan(String maskedPan) {
        this.maskedPan = maskedPan;
    }

    public void setMsisdn(String msisdn) {
        this.msisdn = msisdn;
    }

    public void setCurrency(Currency currency) {
        this.currency = currency;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AccountReference)) {
            return false;
        }
        AccountReference other = (AccountReference)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$aspspAccountId = this.getAspspAccountId();
        String other$aspspAccountId = other.getAspspAccountId();
        if (this$aspspAccountId == null ? other$aspspAccountId != null : !this$aspspAccountId.equals(other$aspspAccountId)) {
            return false;
        }
        String this$resourceId = this.getResourceId();
        String other$resourceId = other.getResourceId();
        if (this$resourceId == null ? other$resourceId != null : !this$resourceId.equals(other$resourceId)) {
            return false;
        }
        String this$iban = this.getIban();
        String other$iban = other.getIban();
        if (this$iban == null ? other$iban != null : !this$iban.equals(other$iban)) {
            return false;
        }
        String this$bban = this.getBban();
        String other$bban = other.getBban();
        if (this$bban == null ? other$bban != null : !this$bban.equals(other$bban)) {
            return false;
        }
        String this$pan = this.getPan();
        String other$pan = other.getPan();
        if (this$pan == null ? other$pan != null : !this$pan.equals(other$pan)) {
            return false;
        }
        String this$maskedPan = this.getMaskedPan();
        String other$maskedPan = other.getMaskedPan();
        if (this$maskedPan == null ? other$maskedPan != null : !this$maskedPan.equals(other$maskedPan)) {
            return false;
        }
        String this$msisdn = this.getMsisdn();
        String other$msisdn = other.getMsisdn();
        if (this$msisdn == null ? other$msisdn != null : !this$msisdn.equals(other$msisdn)) {
            return false;
        }
        Currency this$currency = this.getCurrency();
        Currency other$currency = other.getCurrency();
        return !(this$currency == null ? other$currency != null : !this$currency.equals(other$currency));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AccountReference;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $aspspAccountId = this.getAspspAccountId();
        result = result * 59 + ($aspspAccountId == null ? 43 : $aspspAccountId.hashCode());
        String $resourceId = this.getResourceId();
        result = result * 59 + ($resourceId == null ? 43 : $resourceId.hashCode());
        String $iban = this.getIban();
        result = result * 59 + ($iban == null ? 43 : $iban.hashCode());
        String $bban = this.getBban();
        result = result * 59 + ($bban == null ? 43 : $bban.hashCode());
        String $pan = this.getPan();
        result = result * 59 + ($pan == null ? 43 : $pan.hashCode());
        String $maskedPan = this.getMaskedPan();
        result = result * 59 + ($maskedPan == null ? 43 : $maskedPan.hashCode());
        String $msisdn = this.getMsisdn();
        result = result * 59 + ($msisdn == null ? 43 : $msisdn.hashCode());
        Currency $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        return result;
    }

    public String toString() {
        return "AccountReference(aspspAccountId=" + this.getAspspAccountId() + ", resourceId=" + this.getResourceId() + ", iban=" + this.getIban() + ", bban=" + this.getBban() + ", pan=" + this.getPan() + ", maskedPan=" + this.getMaskedPan() + ", msisdn=" + this.getMsisdn() + ", currency=" + this.getCurrency() + ")";
    }

    @ConstructorProperties(value={"aspspAccountId", "resourceId", "iban", "bban", "pan", "maskedPan", "msisdn", "currency"})
    public AccountReference(String aspspAccountId, String resourceId, String iban, String bban, String pan, String maskedPan, String msisdn, Currency currency) {
        this.aspspAccountId = aspspAccountId;
        this.resourceId = resourceId;
        this.iban = iban;
        this.bban = bban;
        this.pan = pan;
        this.maskedPan = maskedPan;
        this.msisdn = msisdn;
        this.currency = currency;
    }

    public AccountReference() {
    }
}

