/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.core.consent;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public enum ConsentStatus {
    RECEIVED("received", false),
    REJECTED("rejected", true),
    VALID("valid", false),
    REVOKED_BY_PSU("revokedByPsu", true),
    EXPIRED("expired", true),
    TERMINATED_BY_TPP("terminatedByTpp", true),
    TERMINATED_BY_ASPSP("terminatedByAspsp", true),
    PARTIALLY_AUTHORISED("partiallyAuthorised", false);

    private static final Map<String, ConsentStatus> CONTAINER;
    private String value;
    private boolean finalisedStatus;

    public boolean isFinalisedStatus() {
        return this.finalisedStatus;
    }

    private ConsentStatus(String value, boolean finalisedStatus) {
        this.value = value;
        this.finalisedStatus = finalisedStatus;
    }

    public static Optional<ConsentStatus> fromValue(String text) {
        if (text != null) {
            return Optional.ofNullable(CONTAINER.get(text.trim()));
        }
        return Optional.empty();
    }

    public String getValue() {
        return String.valueOf(this.value);
    }

    static {
        CONTAINER = new HashMap<String, ConsentStatus>();
        for (ConsentStatus status : ConsentStatus.values()) {
            CONTAINER.put(status.getValue(), status);
        }
    }
}

