/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.core.profile;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public enum PaymentType {
    SINGLE("payments"),
    BULK("bulk-payments"),
    PERIODIC("periodic-payments");

    private static final Map<String, PaymentType> container;
    private String value;

    @JsonCreator
    private PaymentType(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public static Optional<PaymentType> getByValue(String name) {
        return Optional.ofNullable(container.get(name));
    }

    static {
        container = new HashMap<String, PaymentType>();
        for (PaymentType type : PaymentType.values()) {
            container.put(type.getValue(), type);
        }
    }
}

