/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.core.sca;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum ScaStatus {
    RECEIVED("received", false),
    PSUIDENTIFIED("psuIdentified", false),
    PSUAUTHENTICATED("psuAuthenticated", false),
    SCAMETHODSELECTED("scaMethodSelected", false),
    STARTED("started", false),
    FINALISED("finalised", true),
    FAILED("failed", true),
    EXEMPTED("exempted", false);

    private static final Map<String, ScaStatus> HOLDER;
    private String value;
    private final boolean finalisedStatus;

    public boolean isFinalisedStatus() {
        return this.finalisedStatus;
    }

    private ScaStatus(String value, boolean finalisedStatus) {
        this.value = value;
        this.finalisedStatus = finalisedStatus;
    }

    @JsonCreator
    public static ScaStatus fromValue(String text) {
        return HOLDER.get(text.trim().toLowerCase());
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    static {
        HOLDER = new HashMap<String, ScaStatus>();
        for (ScaStatus status : ScaStatus.values()) {
            HOLDER.put(status.value.toLowerCase(), status);
        }
    }
}

