/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.core.profile;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public enum PaymentProduct {
    SEPA("sepa-credit-transfers"),
    INSTANT_SEPA("instant-sepa-credit-transfers"),
    TARGET2("target-2-payments"),
    CROSS_BORDER("cross-border-credit-transfers");

    private String value;
    private static Map<String, PaymentProduct> container;

    @JsonCreator
    private PaymentProduct(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public static Optional<PaymentProduct> getByValue(String value) {
        return Optional.ofNullable(container.get(value));
    }

    static {
        container = new HashMap<String, PaymentProduct>();
        for (PaymentProduct product : PaymentProduct.values()) {
            container.put(product.getValue(), product);
        }
    }
}

