/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.core.pis;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public enum TransactionStatus {
    ACCP("AcceptedCustomerProfile", false),
    ACSC("AcceptedSettlementCompleted", true),
    ACSP("AcceptedSettlementInProcess", false),
    ACTC("AcceptedTechnicalValidation", false),
    ACWC("AcceptedWithChange", false),
    ACWP("AcceptedWithoutPosting", false),
    RCVD("Received", false),
    PDNG("Pending", false),
    RJCT("Rejected", true),
    CANC("Canceled", true);

    private static Map<String, TransactionStatus> container;
    private String transactionStatus;
    private final boolean finalisedStatus;

    public boolean isFinalisedStatus() {
        return this.finalisedStatus;
    }

    private TransactionStatus(String transactionStatus, boolean finalisedStatus) {
        this.transactionStatus = transactionStatus;
        this.finalisedStatus = finalisedStatus;
    }

    @JsonCreator
    public static TransactionStatus getByValue(String transactionStatus) {
        return container.get(transactionStatus);
    }

    public String getTransactionStatus() {
        return this.transactionStatus;
    }

    static {
        container = new HashMap<String, TransactionStatus>();
        Arrays.stream(TransactionStatus.values()).forEach(status -> container.put(status.getTransactionStatus(), (TransactionStatus)((Object)status)));
    }
}

