/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.core.data;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.adorsys.psd2.core.data.AccountAccess;
import de.adorsys.psd2.xs2a.core.authorisation.AuthorisationTemplate;
import de.adorsys.psd2.xs2a.core.authorisation.ConsentAuthorization;
import de.adorsys.psd2.xs2a.core.consent.ConsentStatus;
import de.adorsys.psd2.xs2a.core.consent.ConsentTppInformation;
import de.adorsys.psd2.xs2a.core.consent.ConsentType;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.core.tpp.TppInfo;
import java.beans.ConstructorProperties;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Consent<T> {
    private T consentData;
    private String id;
    @Nullable
    private String internalRequestId;
    private ConsentStatus consentStatus;
    @NotNull
    private Integer frequencyPerDay;
    private boolean recurringIndicator;
    private boolean multilevelScaRequired;
    @Nullable
    private LocalDate validUntil;
    @Nullable
    private LocalDate expireDate;
    @Nullable
    private LocalDate lastActionDate;
    @Nullable
    private OffsetDateTime creationTimestamp;
    @Nullable
    private OffsetDateTime statusChangeTimestamp;
    @NotNull
    private ConsentTppInformation consentTppInformation;
    @NotNull
    private AuthorisationTemplate authorisationTemplate;
    @NotNull
    private List<PsuIdData> psuIdDataList;
    @NotNull
    private List<ConsentAuthorization> authorisations;
    @NotNull
    private Map<String, Integer> usages;
    @NotNull
    private AccountAccess tppAccountAccesses = AccountAccess.EMPTY_ACCESS;
    @NotNull
    private AccountAccess aspspAccountAccesses = AccountAccess.EMPTY_ACCESS;
    @Nullable
    private String instanceId;
    @NotNull
    private ConsentType consentType;
    private boolean signingBasketBlocked;
    private boolean signingBasketAuthorised;

    public TppInfo getTppInfo() {
        return Optional.ofNullable(this.consentTppInformation).map(ConsentTppInformation::getTppInfo).orElse(null);
    }

    public Optional<ConsentAuthorization> findAuthorisationInConsent(String authorisationId) {
        return this.getAuthorisations().stream().filter(auth -> auth.getId().equals(authorisationId)).findFirst();
    }

    @JsonIgnore
    public boolean isExpired() {
        return this.getConsentStatus() == ConsentStatus.EXPIRED;
    }

    public T getConsentData() {
        return this.consentData;
    }

    public String getId() {
        return this.id;
    }

    @Nullable
    public String getInternalRequestId() {
        return this.internalRequestId;
    }

    public ConsentStatus getConsentStatus() {
        return this.consentStatus;
    }

    @NotNull
    public Integer getFrequencyPerDay() {
        return this.frequencyPerDay;
    }

    public boolean isRecurringIndicator() {
        return this.recurringIndicator;
    }

    public boolean isMultilevelScaRequired() {
        return this.multilevelScaRequired;
    }

    @Nullable
    public LocalDate getValidUntil() {
        return this.validUntil;
    }

    @Nullable
    public LocalDate getExpireDate() {
        return this.expireDate;
    }

    @Nullable
    public LocalDate getLastActionDate() {
        return this.lastActionDate;
    }

    @Nullable
    public OffsetDateTime getCreationTimestamp() {
        return this.creationTimestamp;
    }

    @Nullable
    public OffsetDateTime getStatusChangeTimestamp() {
        return this.statusChangeTimestamp;
    }

    @NotNull
    public ConsentTppInformation getConsentTppInformation() {
        return this.consentTppInformation;
    }

    @NotNull
    public AuthorisationTemplate getAuthorisationTemplate() {
        return this.authorisationTemplate;
    }

    @NotNull
    public List<PsuIdData> getPsuIdDataList() {
        return this.psuIdDataList;
    }

    @NotNull
    public List<ConsentAuthorization> getAuthorisations() {
        return this.authorisations;
    }

    @NotNull
    public Map<String, Integer> getUsages() {
        return this.usages;
    }

    @NotNull
    public AccountAccess getTppAccountAccesses() {
        return this.tppAccountAccesses;
    }

    @NotNull
    public AccountAccess getAspspAccountAccesses() {
        return this.aspspAccountAccesses;
    }

    @Nullable
    public String getInstanceId() {
        return this.instanceId;
    }

    @NotNull
    public ConsentType getConsentType() {
        return this.consentType;
    }

    public boolean isSigningBasketBlocked() {
        return this.signingBasketBlocked;
    }

    public boolean isSigningBasketAuthorised() {
        return this.signingBasketAuthorised;
    }

    public void setConsentData(T consentData) {
        this.consentData = consentData;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setInternalRequestId(@Nullable String internalRequestId) {
        this.internalRequestId = internalRequestId;
    }

    public void setConsentStatus(ConsentStatus consentStatus) {
        this.consentStatus = consentStatus;
    }

    public void setFrequencyPerDay(@NotNull Integer frequencyPerDay) {
        if (frequencyPerDay == null) {
            throw new NullPointerException("frequencyPerDay is marked @NonNull but is null");
        }
        this.frequencyPerDay = frequencyPerDay;
    }

    public void setRecurringIndicator(boolean recurringIndicator) {
        this.recurringIndicator = recurringIndicator;
    }

    public void setMultilevelScaRequired(boolean multilevelScaRequired) {
        this.multilevelScaRequired = multilevelScaRequired;
    }

    public void setValidUntil(@Nullable LocalDate validUntil) {
        this.validUntil = validUntil;
    }

    public void setExpireDate(@Nullable LocalDate expireDate) {
        this.expireDate = expireDate;
    }

    public void setLastActionDate(@Nullable LocalDate lastActionDate) {
        this.lastActionDate = lastActionDate;
    }

    public void setCreationTimestamp(@Nullable OffsetDateTime creationTimestamp) {
        this.creationTimestamp = creationTimestamp;
    }

    public void setStatusChangeTimestamp(@Nullable OffsetDateTime statusChangeTimestamp) {
        this.statusChangeTimestamp = statusChangeTimestamp;
    }

    public void setConsentTppInformation(@NotNull ConsentTppInformation consentTppInformation) {
        if (consentTppInformation == null) {
            throw new NullPointerException("consentTppInformation is marked @NonNull but is null");
        }
        this.consentTppInformation = consentTppInformation;
    }

    public void setAuthorisationTemplate(@NotNull AuthorisationTemplate authorisationTemplate) {
        if (authorisationTemplate == null) {
            throw new NullPointerException("authorisationTemplate is marked @NonNull but is null");
        }
        this.authorisationTemplate = authorisationTemplate;
    }

    public void setPsuIdDataList(@NotNull List<PsuIdData> psuIdDataList) {
        if (psuIdDataList == null) {
            throw new NullPointerException("psuIdDataList is marked @NonNull but is null");
        }
        this.psuIdDataList = psuIdDataList;
    }

    public void setAuthorisations(@NotNull List<ConsentAuthorization> authorisations) {
        if (authorisations == null) {
            throw new NullPointerException("authorisations is marked @NonNull but is null");
        }
        this.authorisations = authorisations;
    }

    public void setUsages(@NotNull Map<String, Integer> usages) {
        if (usages == null) {
            throw new NullPointerException("usages is marked @NonNull but is null");
        }
        this.usages = usages;
    }

    public void setTppAccountAccesses(@NotNull AccountAccess tppAccountAccesses) {
        if (tppAccountAccesses == null) {
            throw new NullPointerException("tppAccountAccesses is marked @NonNull but is null");
        }
        this.tppAccountAccesses = tppAccountAccesses;
    }

    public void setAspspAccountAccesses(@NotNull AccountAccess aspspAccountAccesses) {
        if (aspspAccountAccesses == null) {
            throw new NullPointerException("aspspAccountAccesses is marked @NonNull but is null");
        }
        this.aspspAccountAccesses = aspspAccountAccesses;
    }

    public void setInstanceId(@Nullable String instanceId) {
        this.instanceId = instanceId;
    }

    public void setConsentType(@NotNull ConsentType consentType) {
        if (consentType == null) {
            throw new NullPointerException("consentType is marked @NonNull but is null");
        }
        this.consentType = consentType;
    }

    public void setSigningBasketBlocked(boolean signingBasketBlocked) {
        this.signingBasketBlocked = signingBasketBlocked;
    }

    public void setSigningBasketAuthorised(boolean signingBasketAuthorised) {
        this.signingBasketAuthorised = signingBasketAuthorised;
    }

    public String toString() {
        return "Consent(consentData=" + this.getConsentData() + ", id=" + this.getId() + ", internalRequestId=" + this.getInternalRequestId() + ", consentStatus=" + this.getConsentStatus() + ", frequencyPerDay=" + this.getFrequencyPerDay() + ", recurringIndicator=" + this.isRecurringIndicator() + ", multilevelScaRequired=" + this.isMultilevelScaRequired() + ", validUntil=" + this.getValidUntil() + ", expireDate=" + this.getExpireDate() + ", lastActionDate=" + this.getLastActionDate() + ", creationTimestamp=" + this.getCreationTimestamp() + ", statusChangeTimestamp=" + this.getStatusChangeTimestamp() + ", consentTppInformation=" + this.getConsentTppInformation() + ", authorisationTemplate=" + this.getAuthorisationTemplate() + ", psuIdDataList=" + this.getPsuIdDataList() + ", authorisations=" + this.getAuthorisations() + ", usages=" + this.getUsages() + ", tppAccountAccesses=" + this.getTppAccountAccesses() + ", aspspAccountAccesses=" + this.getAspspAccountAccesses() + ", instanceId=" + this.getInstanceId() + ", consentType=" + this.getConsentType() + ", signingBasketBlocked=" + this.isSigningBasketBlocked() + ", signingBasketAuthorised=" + this.isSigningBasketAuthorised() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Consent)) {
            return false;
        }
        Consent other = (Consent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        T this$consentData = this.getConsentData();
        T other$consentData = other.getConsentData();
        if (this$consentData == null ? other$consentData != null : !this$consentData.equals(other$consentData)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$internalRequestId = this.getInternalRequestId();
        String other$internalRequestId = other.getInternalRequestId();
        if (this$internalRequestId == null ? other$internalRequestId != null : !this$internalRequestId.equals(other$internalRequestId)) {
            return false;
        }
        ConsentStatus this$consentStatus = this.getConsentStatus();
        ConsentStatus other$consentStatus = other.getConsentStatus();
        if (this$consentStatus == null ? other$consentStatus != null : !this$consentStatus.equals(other$consentStatus)) {
            return false;
        }
        Integer this$frequencyPerDay = this.getFrequencyPerDay();
        Integer other$frequencyPerDay = other.getFrequencyPerDay();
        if (this$frequencyPerDay == null ? other$frequencyPerDay != null : !((Object)this$frequencyPerDay).equals(other$frequencyPerDay)) {
            return false;
        }
        if (this.isRecurringIndicator() != other.isRecurringIndicator()) {
            return false;
        }
        if (this.isMultilevelScaRequired() != other.isMultilevelScaRequired()) {
            return false;
        }
        LocalDate this$validUntil = this.getValidUntil();
        LocalDate other$validUntil = other.getValidUntil();
        if (this$validUntil == null ? other$validUntil != null : !((Object)this$validUntil).equals(other$validUntil)) {
            return false;
        }
        LocalDate this$expireDate = this.getExpireDate();
        LocalDate other$expireDate = other.getExpireDate();
        if (this$expireDate == null ? other$expireDate != null : !((Object)this$expireDate).equals(other$expireDate)) {
            return false;
        }
        LocalDate this$lastActionDate = this.getLastActionDate();
        LocalDate other$lastActionDate = other.getLastActionDate();
        if (this$lastActionDate == null ? other$lastActionDate != null : !((Object)this$lastActionDate).equals(other$lastActionDate)) {
            return false;
        }
        OffsetDateTime this$creationTimestamp = this.getCreationTimestamp();
        OffsetDateTime other$creationTimestamp = other.getCreationTimestamp();
        if (this$creationTimestamp == null ? other$creationTimestamp != null : !((Object)this$creationTimestamp).equals(other$creationTimestamp)) {
            return false;
        }
        OffsetDateTime this$statusChangeTimestamp = this.getStatusChangeTimestamp();
        OffsetDateTime other$statusChangeTimestamp = other.getStatusChangeTimestamp();
        if (this$statusChangeTimestamp == null ? other$statusChangeTimestamp != null : !((Object)this$statusChangeTimestamp).equals(other$statusChangeTimestamp)) {
            return false;
        }
        ConsentTppInformation this$consentTppInformation = this.getConsentTppInformation();
        ConsentTppInformation other$consentTppInformation = other.getConsentTppInformation();
        if (this$consentTppInformation == null ? other$consentTppInformation != null : !this$consentTppInformation.equals(other$consentTppInformation)) {
            return false;
        }
        AuthorisationTemplate this$authorisationTemplate = this.getAuthorisationTemplate();
        AuthorisationTemplate other$authorisationTemplate = other.getAuthorisationTemplate();
        if (this$authorisationTemplate == null ? other$authorisationTemplate != null : !this$authorisationTemplate.equals(other$authorisationTemplate)) {
            return false;
        }
        List<PsuIdData> this$psuIdDataList = this.getPsuIdDataList();
        List<PsuIdData> other$psuIdDataList = other.getPsuIdDataList();
        if (this$psuIdDataList == null ? other$psuIdDataList != null : !((Object)this$psuIdDataList).equals(other$psuIdDataList)) {
            return false;
        }
        List<ConsentAuthorization> this$authorisations = this.getAuthorisations();
        List<ConsentAuthorization> other$authorisations = other.getAuthorisations();
        if (this$authorisations == null ? other$authorisations != null : !((Object)this$authorisations).equals(other$authorisations)) {
            return false;
        }
        Map<String, Integer> this$usages = this.getUsages();
        Map<String, Integer> other$usages = other.getUsages();
        if (this$usages == null ? other$usages != null : !((Object)this$usages).equals(other$usages)) {
            return false;
        }
        AccountAccess this$tppAccountAccesses = this.getTppAccountAccesses();
        AccountAccess other$tppAccountAccesses = other.getTppAccountAccesses();
        if (this$tppAccountAccesses == null ? other$tppAccountAccesses != null : !((Object)this$tppAccountAccesses).equals(other$tppAccountAccesses)) {
            return false;
        }
        AccountAccess this$aspspAccountAccesses = this.getAspspAccountAccesses();
        AccountAccess other$aspspAccountAccesses = other.getAspspAccountAccesses();
        if (this$aspspAccountAccesses == null ? other$aspspAccountAccesses != null : !((Object)this$aspspAccountAccesses).equals(other$aspspAccountAccesses)) {
            return false;
        }
        String this$instanceId = this.getInstanceId();
        String other$instanceId = other.getInstanceId();
        if (this$instanceId == null ? other$instanceId != null : !this$instanceId.equals(other$instanceId)) {
            return false;
        }
        ConsentType this$consentType = this.getConsentType();
        ConsentType other$consentType = other.getConsentType();
        if (this$consentType == null ? other$consentType != null : !this$consentType.equals(other$consentType)) {
            return false;
        }
        if (this.isSigningBasketBlocked() != other.isSigningBasketBlocked()) {
            return false;
        }
        return this.isSigningBasketAuthorised() == other.isSigningBasketAuthorised();
    }

    protected boolean canEqual(Object other) {
        return other instanceof Consent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        T $consentData = this.getConsentData();
        result = result * 59 + ($consentData == null ? 43 : $consentData.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $internalRequestId = this.getInternalRequestId();
        result = result * 59 + ($internalRequestId == null ? 43 : $internalRequestId.hashCode());
        ConsentStatus $consentStatus = this.getConsentStatus();
        result = result * 59 + ($consentStatus == null ? 43 : $consentStatus.hashCode());
        Integer $frequencyPerDay = this.getFrequencyPerDay();
        result = result * 59 + ($frequencyPerDay == null ? 43 : ((Object)$frequencyPerDay).hashCode());
        result = result * 59 + (this.isRecurringIndicator() ? 79 : 97);
        result = result * 59 + (this.isMultilevelScaRequired() ? 79 : 97);
        LocalDate $validUntil = this.getValidUntil();
        result = result * 59 + ($validUntil == null ? 43 : ((Object)$validUntil).hashCode());
        LocalDate $expireDate = this.getExpireDate();
        result = result * 59 + ($expireDate == null ? 43 : ((Object)$expireDate).hashCode());
        LocalDate $lastActionDate = this.getLastActionDate();
        result = result * 59 + ($lastActionDate == null ? 43 : ((Object)$lastActionDate).hashCode());
        OffsetDateTime $creationTimestamp = this.getCreationTimestamp();
        result = result * 59 + ($creationTimestamp == null ? 43 : ((Object)$creationTimestamp).hashCode());
        OffsetDateTime $statusChangeTimestamp = this.getStatusChangeTimestamp();
        result = result * 59 + ($statusChangeTimestamp == null ? 43 : ((Object)$statusChangeTimestamp).hashCode());
        ConsentTppInformation $consentTppInformation = this.getConsentTppInformation();
        result = result * 59 + ($consentTppInformation == null ? 43 : $consentTppInformation.hashCode());
        AuthorisationTemplate $authorisationTemplate = this.getAuthorisationTemplate();
        result = result * 59 + ($authorisationTemplate == null ? 43 : $authorisationTemplate.hashCode());
        List<PsuIdData> $psuIdDataList = this.getPsuIdDataList();
        result = result * 59 + ($psuIdDataList == null ? 43 : ((Object)$psuIdDataList).hashCode());
        List<ConsentAuthorization> $authorisations = this.getAuthorisations();
        result = result * 59 + ($authorisations == null ? 43 : ((Object)$authorisations).hashCode());
        Map<String, Integer> $usages = this.getUsages();
        result = result * 59 + ($usages == null ? 43 : ((Object)$usages).hashCode());
        AccountAccess $tppAccountAccesses = this.getTppAccountAccesses();
        result = result * 59 + ($tppAccountAccesses == null ? 43 : ((Object)$tppAccountAccesses).hashCode());
        AccountAccess $aspspAccountAccesses = this.getAspspAccountAccesses();
        result = result * 59 + ($aspspAccountAccesses == null ? 43 : ((Object)$aspspAccountAccesses).hashCode());
        String $instanceId = this.getInstanceId();
        result = result * 59 + ($instanceId == null ? 43 : $instanceId.hashCode());
        ConsentType $consentType = this.getConsentType();
        result = result * 59 + ($consentType == null ? 43 : $consentType.hashCode());
        result = result * 59 + (this.isSigningBasketBlocked() ? 79 : 97);
        result = result * 59 + (this.isSigningBasketAuthorised() ? 79 : 97);
        return result;
    }

    @ConstructorProperties(value={"consentData", "id", "internalRequestId", "consentStatus", "frequencyPerDay", "recurringIndicator", "multilevelScaRequired", "validUntil", "expireDate", "lastActionDate", "creationTimestamp", "statusChangeTimestamp", "consentTppInformation", "authorisationTemplate", "psuIdDataList", "authorisations", "usages", "tppAccountAccesses", "aspspAccountAccesses", "instanceId", "consentType", "signingBasketBlocked", "signingBasketAuthorised"})
    public Consent(T consentData, String id, @Nullable String internalRequestId, ConsentStatus consentStatus, @NotNull Integer frequencyPerDay, boolean recurringIndicator, boolean multilevelScaRequired, @Nullable LocalDate validUntil, @Nullable LocalDate expireDate, @Nullable LocalDate lastActionDate, @Nullable OffsetDateTime creationTimestamp, @Nullable OffsetDateTime statusChangeTimestamp, @NotNull ConsentTppInformation consentTppInformation, @NotNull AuthorisationTemplate authorisationTemplate, @NotNull List<PsuIdData> psuIdDataList, @NotNull List<ConsentAuthorization> authorisations, @NotNull Map<String, Integer> usages, @NotNull AccountAccess tppAccountAccesses, @NotNull AccountAccess aspspAccountAccesses, @Nullable String instanceId, @NotNull ConsentType consentType, boolean signingBasketBlocked, boolean signingBasketAuthorised) {
        if (frequencyPerDay == null) {
            throw new NullPointerException("frequencyPerDay is marked @NonNull but is null");
        }
        if (consentTppInformation == null) {
            throw new NullPointerException("consentTppInformation is marked @NonNull but is null");
        }
        if (authorisationTemplate == null) {
            throw new NullPointerException("authorisationTemplate is marked @NonNull but is null");
        }
        if (psuIdDataList == null) {
            throw new NullPointerException("psuIdDataList is marked @NonNull but is null");
        }
        if (authorisations == null) {
            throw new NullPointerException("authorisations is marked @NonNull but is null");
        }
        if (usages == null) {
            throw new NullPointerException("usages is marked @NonNull but is null");
        }
        if (tppAccountAccesses == null) {
            throw new NullPointerException("tppAccountAccesses is marked @NonNull but is null");
        }
        if (aspspAccountAccesses == null) {
            throw new NullPointerException("aspspAccountAccesses is marked @NonNull but is null");
        }
        if (consentType == null) {
            throw new NullPointerException("consentType is marked @NonNull but is null");
        }
        this.consentData = consentData;
        this.id = id;
        this.internalRequestId = internalRequestId;
        this.consentStatus = consentStatus;
        this.frequencyPerDay = frequencyPerDay;
        this.recurringIndicator = recurringIndicator;
        this.multilevelScaRequired = multilevelScaRequired;
        this.validUntil = validUntil;
        this.expireDate = expireDate;
        this.lastActionDate = lastActionDate;
        this.creationTimestamp = creationTimestamp;
        this.statusChangeTimestamp = statusChangeTimestamp;
        this.consentTppInformation = consentTppInformation;
        this.authorisationTemplate = authorisationTemplate;
        this.psuIdDataList = psuIdDataList;
        this.authorisations = authorisations;
        this.usages = usages;
        this.tppAccountAccesses = tppAccountAccesses;
        this.aspspAccountAccesses = aspspAccountAccesses;
        this.instanceId = instanceId;
        this.consentType = consentType;
        this.signingBasketBlocked = signingBasketBlocked;
        this.signingBasketAuthorised = signingBasketAuthorised;
    }

    public Consent() {
    }
}

